/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.astrogrid.samp.SampUtils;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.server.FormServlet;
import uk.ac.starlink.ttools.server.PlotServlet;
import uk.ac.starlink.ttools.server.TaskServlet;
import uk.ac.starlink.ttools.task.TableFactoryParameter;
import uk.ac.starlink.util.ObjectFactory;

public class StiltsServer
implements Task {
    private final IntegerParameter portParam_ = new IntegerParameter("port");
    private final StringParameter baseParam_;
    private final StringParameter tasksParam_;
    private final TableFactoryParameter tfactParam_;

    public StiltsServer() {
        this.portParam_.setPrompt("Server port");
        this.portParam_.setDescription(new String[]{"<p>Port number on which the server should run.", "</p>"});
        this.portParam_.setIntDefault(2112);
        this.baseParam_ = new StringParameter("basepath");
        this.baseParam_.setPrompt("Base path for server URLs");
        String baseDefault = "/stilts";
        this.baseParam_.setDescription(new String[]{"<p>Base path on the server at which request URLs are rooted.", "The default is <code>" + baseDefault + "</code>, which means that", "for instance requests to execute task <code>plot2d</code>", "should be directed to the URL", "<code>http://host:portnum" + baseDefault + "/task/plot2d?name=value&amp;name=value...</code>", "</p>"});
        this.baseParam_.setNullPermitted(true);
        this.baseParam_.setStringDefault(baseDefault);
        this.tasksParam_ = new StringParameter("tasks");
        this.tasksParam_.setPrompt("List of tasks provided");
        this.tasksParam_.setUsage("<task-name> ...");
        this.tasksParam_.setNullPermitted(true);
        this.tasksParam_.setDescription(new String[]{"<p>Gives a space-separated list of tasks which will be provided", "by the relevant endpoints of the running server.", "If the value is <code>null</code> then all tasks will be", "available.  However, some tasks don't make a lot of sense", "to run from the server, so the default value is a somewhat", "restricted list.", "If the server is being exposed to external users, you might", "also want to reduce the list for security reasons.", "If you don't want any tasks made available,", "for instance if you want to run the plot service only,", "you can set this to the empty string.", "</p>"});
        ObjectFactory<Task> taskFactory = Stilts.getTaskFactory();
        ArrayList<String> taskList = new ArrayList<String>(Arrays.asList(taskFactory.getNickNames()));
        taskList.removeAll(Arrays.asList("server", "funcs"));
        StringBuffer taskBuf = new StringBuffer();
        Iterator it = taskList.iterator();
        while (it.hasNext()) {
            taskBuf.append((String)it.next());
            if (!it.hasNext()) continue;
            taskBuf.append(' ');
        }
        String tasksDefault = taskBuf.toString();
        TaskServlet.getTaskNames(taskFactory, tasksDefault);
        this.tasksParam_.setStringDefault(tasksDefault);
        this.tfactParam_ = new TableFactoryParameter("tablefactory");
    }

    public String getPurpose() {
        return "Runs an HTTP server to perform STILTS commands";
    }

    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.portParam_, this.baseParam_, this.tasksParam_, this.tfactParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        final int port = this.portParam_.intValue(env);
        String basePath = this.baseParam_.stringValue(env);
        final String base = basePath == null ? "" : basePath;
        final String tasks = this.tasksParam_.stringValue(env);
        final String factorySpec = this.tfactParam_.stringValue(env);
        try {
            TaskServlet.getTaskNames(Stilts.getTaskFactory(), tasks);
        }
        catch (Exception e) {
            throw new ParameterValueException((Parameter)this.tasksParam_, e.toString(), (Throwable)e);
        }
        final PrintStream out = env.getOutputStream();
        return new Executable(){

            public void execute() throws IOException {
                HttpServer server = new HttpServer();
                server.addListener(new InetAddrPort(port));
                HttpContext context = server.getContext("/");
                ServletHandler handler = new ServletHandler();
                context.addHandler((HttpHandler)handler);
                ArrayList<String> baseList = new ArrayList<String>();
                handler.addServlet("STILTS plot2", base + "/plot/*", PlotServlet.class.getName());
                baseList.add(base + "/plot/");
                handler.addServlet("STILTS Tasks", base + "/task/*", TaskServlet.class.getName());
                baseList.add(base + "/task/");
                handler.addServlet("STILTS Forms", base + "/form/*", FormServlet.class.getName());
                baseList.add(base + "/form/");
                String[] bases = baseList.toArray(new String[0]);
                context.addHandler((HttpHandler)new FallbackHandler(bases));
                context.setInitParameter("stiltsTaskBase", base + "/task");
                context.setInitParameter("stiltsTasks", tasks);
                if (factorySpec != null) {
                    context.setInitParameter("tableFactory", factorySpec);
                }
                try {
                    server.start();
                    String url = "http://" + SampUtils.getLocalhost() + ":" + port + base + "/";
                    out.println("Server running at " + url);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Can't start server").initCause(e);
                }
            }
        };
    }

    private static class FallbackHandler
    extends NotFoundHandler {
        private final String[] paths_;

        FallbackHandler(String[] paths) {
            this.paths_ = paths;
        }

        public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
            response.setContentType("text/html");
            response.setStatus(404);
            response.setReason("Not Found");
            PrintStream out = new PrintStream(response.getOutputStream());
            out.println("<html>");
            out.println("<head><title>404 Not Found</title></head>");
            out.println("<body>");
            out.println("<h2>No such resource</h2>");
            out.println("Try one of these:");
            out.println("<ul>");
            for (int i = 0; i < this.paths_.length; ++i) {
                String path = this.paths_[i];
                out.println("<li><a href='" + path + "'>" + path + "</a></li>");
            }
            out.println("</ul>");
            out.println("<p><i><a href='http://www.starlink.ac.uk/stilts/'>STILTS</a> Server " + Stilts.getVersion() + "</i></p>");
            out.println("<body>");
            out.println("</html>");
            out.close();
            response.commit();
        }
    }
}

