/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapLinter;
import uk.ac.starlink.ttools.task.OutputReporterParameter;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TapServiceParams;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapService;

public class TapLint
implements Task {
    private final TapLinter tapLinter_;
    private final OutputReporterParameter reporterParam_;
    private final TapServiceParams tapserviceParams_;
    private final StringMultiParameter stagesParam_;
    private final IntegerParameter maxtableParam_;
    private final StringParameter tablesParam_;
    private final Parameter<?>[] params_;

    public TapLint() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.tapserviceParams_ = new TapServiceParams("tapurl", true);
        URLParameter urlParam = this.tapserviceParams_.getBaseParameter();
        urlParam.setPosition(1);
        paramList.add(urlParam);
        this.stagesParam_ = new StringMultiParameter("stages", ' ');
        this.stagesParam_.setPrompt("Codes for validation stages to run");
        this.tapLinter_ = new TapLinter();
        Map<String, Stage> stageMap = this.tapLinter_.getKnownStages();
        StringBuffer sbuf = new StringBuffer();
        for (String code : stageMap.keySet()) {
            Stage stage = stageMap.get(code);
            boolean on = this.tapLinter_.isDefault(code);
            sbuf.append("<li>").append("<code>").append(code).append("</code>").append(": ").append(stage.getDescription()).append(on ? "" : " (off)").append("</li>").append("\n");
        }
        this.stagesParam_.setUsage("[+/-]XXX ...");
        this.stagesParam_.setNullPermitted(true);
        this.stagesParam_.setDescription(new String[]{"<p>Determines the validation stages which the validator", "will peform.", "Each stage is represented by a short code, as follows:", "<ul>", sbuf.toString(), "</ul>", "</p>", "<p>This parameter can specify what stages to run", "in the following ways:", "<ul>", "<li>if left blank, the default list of stages", "    (which is most or all of them) will be run</li>", "<li>if the value is a space-separated list of three-letter codes,", "    it lists the stages that will be run</li>", "<li>if the value is a space separated list of three-letter codes", "    preceded by a \"+\" or \"-\" character, the named stages", "    will be removed or added to the default list</li>", "</ul>", "So \"<code>TME CAP</code>\" will run only Table Metadata and", "Capability stages,", "while \"<code>-EXA -UPL</code>\" will run all the default stages", "apart from Examples and Upload.", "The order in which stages are listed is not significant.", "</p>", "<p>Note that removing some stages may affect the operation", "of others;", "for instance table metadata is acquired from the metadata stages,", "and avoiding those will mean that later stages which use", "the table metadata to pose queries will not be able to do so", "with knowledge of the database schema.", "</p>"});
        paramList.add((Object)this.stagesParam_);
        this.maxtableParam_ = new IntegerParameter("maxtable");
        this.maxtableParam_.setPrompt("Maximum number of tables tested individually");
        this.maxtableParam_.setDescription(new String[]{"<p>Limits the number of tables from the service", "that will be tested.", "Currently, this only affects", "stage <code>MDQ</code>.", "If the value is left blank (the default),", "or if it is larger than the number of tables actually", "present in the service, it will have no effect.", "</p>"});
        this.maxtableParam_.setMinimum(1);
        this.maxtableParam_.setNullPermitted(true);
        paramList.add(this.maxtableParam_);
        this.tablesParam_ = new StringParameter("tables");
        this.tablesParam_.setPrompt("Selected table names");
        this.tablesParam_.setUsage("<name-list>");
        this.tablesParam_.setDescription(new String[]{"<p>If supplied, this specifies a list of tables to test.", "It may be set to a space- or comma-separated list", "of table names for consideration;", "any tables not covered by this list are mostly ignored", "for the purposes of reporting.", "Matching against table names is case-insensitive,", "and the asterisk character \"<code>*</code>\"", "may be used as a wildcard to match any sequence of characters.", "Note that matching is against the declared table name", "which may or may not include a schema name prefix", "depending on service behaviour.", "</p>", "<p>By default this parameter is not set,", "which means that all tables are considered.", "</p>"});
        this.tablesParam_.setNullPermitted(true);
        paramList.add(this.tablesParam_);
        this.reporterParam_ = new OutputReporterParameter("format");
        paramList.add((Object)this.reporterParam_);
        paramList.addAll(Arrays.asList(this.reporterParam_.getReporterParameters()));
        paramList.addAll(this.tapserviceParams_.getInterfaceParameters());
        paramList.addAll(this.tapserviceParams_.getOtherParameters());
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public String getPurpose() {
        return "Tests TAP services";
    }

    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        IOSupplier<TapService> serviceSupplier;
        final OutputReporter reporter = (OutputReporter)this.reporterParam_.objectValue(env);
        Integer maxTablesObj = (Integer)this.maxtableParam_.objectValue(env);
        int maxTestTables = maxTablesObj == null ? -1 : maxTablesObj;
        Set<String> stageSet = this.getStageSet(this.stagesParam_.stringsValue(env));
        Predicate<TableMeta> tableFilter = TapLint.createTableNameFilter((String)this.tablesParam_.objectValue(env));
        try {
            serviceSupplier = this.tapserviceParams_.getServiceSupplier(env);
        }
        catch (ExecutionException e) {
            return new Executable(){

                public void execute() {
                    reporter.start(TapLinter.getAnnouncements(false));
                    reporter.startSection("PRE", "Preparation");
                    reporter.report(FixedCode.E_TAP0, "TAP service not present", (Throwable)e);
                    reporter.endSection();
                    reporter.end();
                }
            };
        }
        return this.tapLinter_.createExecutable(reporter, serviceSupplier, stageSet, maxTestTables, tableFilter);
    }

    private Set<String> getStageSet(String[] stageStrings) throws ParameterValueException {
        Set<String> knownStages = this.tapLinter_.getKnownStages().keySet();
        Collection dfltStages = this.tapLinter_.getKnownStages().keySet().stream().filter(this.tapLinter_::isDefault).collect(Collectors.toSet());
        for (String s : knownStages) {
            assert (s.length() == 3 && s.equals(s.toUpperCase()));
        }
        if (stageStrings == null || stageStrings.length == 0) {
            return new HashSet<String>(dfltStages);
        }
        Pattern stageRegex = Pattern.compile("([+-]?)([A-Za-z]{3})");
        HashSet<String> adds = new HashSet<String>();
        HashSet<String> removes = new HashSet<String>();
        HashSet<String> selects = new HashSet<String>();
        for (String stageString : stageStrings) {
            Matcher matcher = stageRegex.matcher(stageString);
            if (matcher.matches()) {
                String flagChar = matcher.group(1);
                String sname = matcher.group(2).toUpperCase();
                if (knownStages.contains(sname)) {
                    if ("+".equals(flagChar)) {
                        adds.add(sname);
                        continue;
                    }
                    if ("-".equals(flagChar)) {
                        removes.add(sname);
                        continue;
                    }
                    assert (flagChar == null || flagChar.length() == 0);
                    selects.add(sname);
                    continue;
                }
                String msg = new StringBuffer().append("Unknown stage \"").append(sname).append("\": stages are ").append(String.join((CharSequence)", ", knownStages)).toString();
                throw new ParameterValueException((Parameter)this.stagesParam_, msg);
            }
            throw new ParameterValueException((Parameter)this.stagesParam_, "Bad stage specification \"" + stageString + "\"");
        }
        if (selects.size() == 0) {
            HashSet<String> stageSet = new HashSet<String>(dfltStages);
            stageSet.addAll(adds);
            stageSet.removeAll(removes);
            return stageSet;
        }
        if (adds.size() == 0 && removes.size() == 0) {
            return new HashSet<String>(selects);
        }
        throw new ParameterValueException((Parameter)this.stagesParam_, "Can't mix +XXX/-XXX and XXX items");
    }

    private static Predicate<TableMeta> createTableNameFilter(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        List patterns = Arrays.stream(txt.split("[\\s,]+", 0)).map(TapLint::globToRegex).collect(Collectors.toList());
        return tmeta -> {
            String tname = tmeta == null ? null : tmeta.getName();
            return tname != null && patterns.stream().anyMatch(p -> p.matcher(tname).matches());
        };
    }

    private static Pattern globToRegex(String glob) {
        String regex = glob == null || glob.trim().length() == 0 ? "" : "\\Q" + glob.replaceAll("\\*", "\\\\E.*\\\\Q") + "\\E";
        return Pattern.compile(regex, 2);
    }
}

