/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.vo.TapCapabilitiesDoc;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapServices;
import uk.ac.starlink.vo.TapVersion;

public class TapServiceParams {
    private final URLParameter baseParam_;
    private final Parameter<String> intfParam_;
    private final BooleanParameter authParam_;
    private final EndpointParameter syncParam_;
    private final EndpointParameter asyncParam_;
    private final EndpointParameter tablesParam_;
    private final EndpointParameter capabilitiesParam_;
    private final EndpointParameter availabilityParam_;
    private final EndpointParameter examplesParam_;
    private final URLParameter[] otherParams_;
    private final String INTFPARAM_NAME = "interface";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public TapServiceParams(String baseParamName, boolean readCapabilitiesDflt) {
        this.baseParam_ = new URLParameter(baseParamName);
        this.baseParam_.setPrompt("Base URL of TAP service");
        URLParameter[] uRLParameterArray = new URLParameter[6];
        this.syncParam_ = new EndpointParameter("sync");
        uRLParameterArray[0] = this.syncParam_;
        this.asyncParam_ = new EndpointParameter("async");
        uRLParameterArray[1] = this.asyncParam_;
        this.tablesParam_ = new EndpointParameter("tables");
        uRLParameterArray[2] = this.tablesParam_;
        this.capabilitiesParam_ = new EndpointParameter("capabilities");
        uRLParameterArray[3] = this.capabilitiesParam_;
        this.availabilityParam_ = new EndpointParameter("availability");
        uRLParameterArray[4] = this.availabilityParam_;
        this.examplesParam_ = new EndpointParameter("examples");
        uRLParameterArray[5] = this.examplesParam_;
        this.otherParams_ = uRLParameterArray;
        StringBuffer obuf = new StringBuffer();
        for (int i = 0; i < this.otherParams_.length; ++i) {
            obuf.append(i == 0 ? "(" : ", ").append("<code>").append(this.otherParams_[i].getName()).append("</code>");
        }
        obuf.append(")");
        String otherTxt = obuf.toString();
        this.baseParam_.setDescription(new String[]{"<p>The base URL of a Table Access Protocol service.", "This is the bare URL without a trailing \"/[a]sync\".", "</p>", "<p>In the usual case, the default values of the various endpoints", "(sync and async query submission, tables metadata,", "service-provided examples etc)", "use this URL as a parent", "and append standard sub-paths.", "</p>", "<p>In some cases however, determination of the endpoints is", "more complicated, as determined by", "the <code>interface</code> parameter", "which may cause endpoints to be read from the capabilities", "document at", "<code>" + this.baseParam_.getName() + "/capabilities</code>,", "and by other endpoint-specific parameters", otherTxt, "for fine tuning.", "</p>"});
        this.intfParam_ = new StringParameter("interface");
        this.intfParam_.setPrompt("TAP interface label");
        this.intfParam_.setUsage("tap1.0|tap1.1|cap");
        this.intfParam_.setDescription(new String[]{"<p>Defines how the service endpoints and", "the version of the TAP protocol to use for queries is determined.", "This may take one of the following (case-insensitive) values:", "<ul>", "<li><code>TAP1.0</code>:", "The standard TAP endpoints are used,", "without examining the service's capabilities document.", "The service is queried using version 1.0 of the TAP protocol.", "</li>", "<li><code>TAP1.1</code>:", "The standard TAP endpoints are used,", "without examining the service's capabilities document.", "The service is queried using version 1.1 of the TAP protocol.", "</li>", "<li><code>cap</code>:", "The service's capabilities document is examined,", "and the endpoints listed there are used.", "</li>", "</ul>", "</p>", "<p>The capabilities document, if used, is read from", "<code>" + this.baseParam_.getName() + "</code>/capabilities", "unless the <code>" + this.capabilitiesParam_.getName() + "</code>", "parameter is defined, in which case that is used.", "</p>", "<p>The baseline value of all the TAP service endpoints", "(<code>sync</code>, <code>async</code>, <code>tables</code>,", "<code>capabilities</code>, <code>examples</code>)", "are determined by this parameter,", "but each of those endpoint values may be overridden", "individually by other endpoint-specific parameters", otherTxt, "</p>", "<p>For default (unauthenticated) access,", "the default value is usually suitable.", "</p>"});
        this.intfParam_.setStringDefault(readCapabilitiesDflt ? "cap" : "tap1.0");
        this.intfParam_.setNullPermitted(true);
        this.authParam_ = new BooleanParameter("auth");
        this.authParam_.setPrompt("Attempt optional authentication?");
        this.authParam_.setDescription(new String[]{"<p>If true, then an attempt will be made to", "<ref id='AuthManager'>authenticate</ref>", "with the TAP service even if anonymous operation is permitted.", "If the service offers authentication,", "you will be asked for credentials.", "</p>", "<p>To use this option in non-interactive contexts,", "you may want to use the", "<code>auth.username</code> and <code>auth.password</code>", "<ref id='sysProperties'>system properties</ref>.", "</p>"});
        this.authParam_.setBooleanDefault(false);
    }

    public URLParameter getBaseParameter() {
        return this.baseParam_;
    }

    public List<Parameter<?>> getInterfaceParameters() {
        ArrayList intfParams = new ArrayList();
        intfParams.add(this.intfParam_);
        intfParams.add((Parameter<?>)this.authParam_);
        return intfParams;
    }

    public List<URLParameter> getOtherParameters() {
        return Arrays.asList(this.otherParams_);
    }

    public Parameter<Boolean> getAuthParameter() {
        return this.authParam_;
    }

    public Parameter<String> getTapInterfaceParameter() {
        return this.intfParam_;
    }

    public IOSupplier<TapService> getServiceSupplier(Environment env) throws TaskException {
        TapService baseService;
        String intfkey = (String)this.intfParam_.objectValue(env);
        if (intfkey == null || intfkey.trim().length() == 0) {
            throw new ParameterValueException(this.intfParam_, "Null not permitted");
        }
        if ("TAP1.0".equalsIgnoreCase(intfkey)) {
            baseService = this.createStandardTapService(env, TapVersion.V10);
        } else if ("TAP1.1".equalsIgnoreCase(intfkey)) {
            baseService = this.createStandardTapService(env, TapVersion.V11);
        } else if ("cap".equalsIgnoreCase(intfkey)) {
            baseService = this.createCapabilitiesTapService(env);
        } else {
            throw new ParameterValueException(this.intfParam_, "Unknown interface format");
        }
        final URL syncUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.syncParam_, baseService.getSyncEndpoint());
        final URL asyncUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.asyncParam_, baseService.getAsyncEndpoint());
        final URL tablesUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.tablesParam_, baseService.getTablesEndpoint());
        final URL capabilitiesUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.capabilitiesParam_, baseService.getCapabilitiesEndpoint());
        final URL availabilityUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.availabilityParam_, baseService.getAvailabilityEndpoint());
        final URL examplesUrl = TapServiceParams.getEndpoint(env, (Parameter<URL>)this.examplesParam_, baseService.getExamplesEndpoint());
        final String baseUrl = baseService.getIdentity();
        final TapVersion tapVersion = baseService.getTapVersion();
        logger_.config("TAP version:        " + tapVersion);
        logger_.config("TAP base URL:       " + baseUrl);
        if (!syncUrl.equals(baseService.getSyncEndpoint())) {
            logger_.config("TAP sync:           " + syncUrl);
        }
        if (!asyncUrl.equals(baseService.getAsyncEndpoint())) {
            logger_.config("TAP async:          " + asyncUrl);
        }
        if (!capabilitiesUrl.equals(baseService.getCapabilitiesEndpoint())) {
            logger_.config("TAP capabilities:   " + capabilitiesUrl);
        }
        if (!tablesUrl.equals(baseService.getTablesEndpoint())) {
            logger_.config("TAP tables:         " + tablesUrl);
        }
        if (!examplesUrl.equals(baseService.getExamplesEndpoint())) {
            logger_.config("TAP examples:       " + examplesUrl);
        }
        if (!availabilityUrl.equals(baseService.getAvailabilityEndpoint())) {
            logger_.config("TAP availability:   " + availabilityUrl);
        }
        TapService service = new TapService(){

            public String getIdentity() {
                return baseUrl;
            }

            public URL getSyncEndpoint() {
                return syncUrl;
            }

            public URL getAsyncEndpoint() {
                return asyncUrl;
            }

            public URL getTablesEndpoint() {
                return tablesUrl;
            }

            public URL getCapabilitiesEndpoint() {
                return capabilitiesUrl;
            }

            public URL getAvailabilityEndpoint() {
                return availabilityUrl;
            }

            public URL getExamplesEndpoint() {
                return examplesUrl;
            }

            public TapVersion getTapVersion() {
                return tapVersion;
            }
        };
        boolean isAuth = this.authParam_.booleanValue(env);
        return () -> {
            if (isAuth) {
                boolean isHead = true;
                boolean forceLogin = true;
                AuthManager.getInstance().authcheck(capabilitiesUrl, isHead, forceLogin);
            }
            return service;
        };
    }

    private static URL getEndpoint(Environment env, Parameter<URL> urlParam, URL dfltUrl) throws TaskException {
        urlParam.setStringDefault(dfltUrl.toString());
        return (URL)urlParam.objectValue(env);
    }

    private TapService createStandardTapService(Environment env, TapVersion tapVersion) throws TaskException {
        URL baseUrl = (URL)this.baseParam_.objectValue(env);
        return TapServices.createTapService((URL)baseUrl, (TapVersion)tapVersion);
    }

    private TapService createCapabilitiesTapService(Environment env) throws TaskException {
        TapCapabilitiesDoc capsDoc;
        URL baseUrl = (URL)this.baseParam_.objectValue(env);
        URL capabilitiesUrl = this.capabilitiesParam_.urlValue(env, baseUrl);
        logger_.info("Reading TAP capabilities from " + capabilitiesUrl);
        try {
            capsDoc = TapCapabilitiesDoc.readCapabilities((URL)capabilitiesUrl);
        }
        catch (IOException e) {
            throw new ExecutionException("Error reading capabilities from " + capabilitiesUrl + ": " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ExecutionException("Error parsing capabilities from " + capabilitiesUrl + ": " + e, (Throwable)e);
        }
        TapService[] services = TapServices.createTapServices((URL)baseUrl, (TapCapabilitiesDoc)capsDoc);
        if (services.length > 0) {
            return services[0];
        }
        throw new TaskException("No TAP services declared in capabilities doc " + capabilitiesUrl);
    }

    private class EndpointParameter
    extends URLParameter {
        private final String label_;

        EndpointParameter(String label) {
            super(label + "url");
            this.label_ = label;
            this.setPrompt("Override URL for TAP " + label + " endpoint");
            this.setDescription(new String[]{"<p>Sets the URL to use for the " + label + " endpoint", "of the TAP service.", "The default value would be", "<code>&lt;" + TapServiceParams.this.baseParam_.getName() + "&gt;/" + label + "</code>,", "but it may be influenced by the chosen", "<code>interface</code> value,", "and it can be further overridden by setting this value.", "</p>"});
            this.setPreferExplicit(false);
        }

        URL urlValue(Environment env, URL baseUrl) throws TaskException {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(baseUrl.toString());
            if (sbuf.charAt(sbuf.length() - 1) != '/') {
                sbuf.append('/');
            }
            sbuf.append(this.label_);
            this.setStringDefault(sbuf.toString());
            return (URL)this.objectValue(env);
        }
    }
}

