/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TablesInput;

public class VariableTablesInput
implements TablesInput {
    private final IntegerParameter ninParam_;
    private final boolean useInFilters_;
    private final Parameter<?>[] params_;
    private final Naming inNaming_;
    public static final String NUM_SUFFIX = "N";

    public VariableTablesInput(boolean useInFilters) {
        this(useInFilters, "in", "input");
    }

    public VariableTablesInput(boolean useInFilters, final String inName, final String inWord) {
        FilterParameter filterParam;
        this.inNaming_ = new Naming(){
            {
                this.pName_ = inName;
                this.pWord_ = inWord;
            }
        };
        this.useInFilters_ = useInFilters;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String numLabel = NUM_SUFFIX;
        InputTableParameter inParam = VariableTablesInput.createInputParameter(numLabel, this.inNaming_);
        paramList.add(inParam.getFormatParameter());
        paramList.add((Object)inParam);
        if (useInFilters) {
            filterParam = VariableTablesInput.createFilterParameter(numLabel, this.inNaming_);
            paramList.add(filterParam);
        } else {
            filterParam = null;
        }
        Parameter[] inParams = paramList.toArray(new Parameter[0]);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < inParams.length; ++i) {
            String pName = inParams[i].getName();
            assert (pName.endsWith(numLabel));
            if (i > 0) {
                sbuf.append(i == inParams.length - 1 ? " and " : ", ");
            }
            sbuf.append("<code>").append(pName).append("</code>");
        }
        String inParamListing = sbuf.toString();
        this.ninParam_ = new IntegerParameter("n" + inName);
        this.ninParam_.setMinimum(1);
        this.ninParam_.setUsage("<count>");
        this.ninParam_.setPrompt("Number of " + inWord + " tables");
        this.ninParam_.setDescription(new String[]{"<p>The number of " + inWord + " tables for this task.", "For each of the " + inWord + " tables " + numLabel, "there will be associated parameters", inParamListing + ".", "</p>"});
        paramList.add(0, this.ninParam_);
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public IntegerParameter getCountParam() {
        return this.ninParam_;
    }

    @Override
    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    @Override
    public InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        int nin = this.ninParam_.intValue(env);
        InputTableSpec[] inSpecs = new InputTableSpec[nin];
        for (int i = 0; i < nin; ++i) {
            String label = VariableTablesInput.indexToLabel(i);
            InputTableParameter inParam = this.createInputParameter(label);
            StarTable table = inParam.tableValue(env);
            String tName = inParam.stringValue(env);
            ProcessingStep[] steps = this.useInFilters_ ? this.createFilterParameter(label).stepsValue(env) : null;
            inSpecs[i] = InputTableSpec.createSpec(tName, steps, table);
        }
        return inSpecs;
    }

    public InputTableParameter getInputTableParameter(int i) {
        return this.createInputParameter(VariableTablesInput.indexToLabel(i));
    }

    @Override
    public FilterParameter getFilterParameter(int i) {
        return this.createFilterParameter(VariableTablesInput.indexToLabel(i));
    }

    public InputTableParameter createInputParameter(String label) {
        return VariableTablesInput.createInputParameter(label, this.inNaming_);
    }

    public FilterParameter createFilterParameter(String label) {
        return VariableTablesInput.createFilterParameter(label, this.inNaming_);
    }

    private static InputTableParameter createInputParameter(String label, Naming naming) {
        InputTableParameter inParam = new InputTableParameter(naming.pName_ + label);
        inParam.setUsage("<table" + label + ">");
        inParam.setPrompt("Location of " + naming.pWord_ + " table " + label);
        inParam.setTableDescription(naming.pWord_ + " table #" + label);
        return inParam;
    }

    private static FilterParameter createFilterParameter(String label, Naming naming) {
        char chr = naming.pName_.charAt(0);
        FilterParameter filterParam = new FilterParameter(chr + "cmd" + label);
        filterParam.setTableDescription(naming.pWord_ + " table #" + label, VariableTablesInput.createInputParameter(label, naming), Boolean.TRUE);
        return filterParam;
    }

    private static String indexToLabel(int i) {
        return String.valueOf(i + 1);
    }

    private static class Naming {
        String pName_;
        String pWord_;

        private Naming() {
        }
    }
}

