/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.taplint.IvoaSchemaResolver;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.util.URLUtils;

public class XsdValidate
implements Task {
    private final Parameter<InputStream> docParam_ = new InputStreamParameter("doc");
    private final Parameter<String[]> schemalocsParam_;
    private final Parameter<String> topelParam_;
    private final BooleanParameter verboseParam_;
    private final BooleanParameter usevolocalsParam_;
    private final BooleanParameter nsurldfltParam_;

    public XsdValidate() {
        this.docParam_.setPosition(1);
        this.docParam_.setPrompt("Document to validate");
        this.docParam_.setDescription(new String[]{"<p>Location of XML document to validate.", "</p>"});
        this.schemalocsParam_ = new StringMultiParameter("schemaloc", ' ');
        this.schemalocsParam_.setUsage("<namespace>=<location> ...");
        this.schemalocsParam_.setPrompt("Schema location overrides");
        this.schemalocsParam_.setDescription(new String[]{"<p>Assignments of override schema locations to XML namespaces.", "One or more assignments may be supplied, each of the form", "<code>&lt;namespace&gt;=&lt;location&gt;</code>", "where the location may be a filename or URL.", "Multiple assignments may be made by supplying the parameter", "multiple times, or using a space character as a separator.", "</p>", "<p>Each assignment causes any reference to the given namespace", "in the validated document to be validated with reference to", "the XSD schema at the given location rather than to", "a schema acquired in the default way", "(using <code>xsi:schemaLocation</code> attributes", "or using the namespace as a retrieval URL).", "</p>"});
        this.schemalocsParam_.setNullPermitted(true);
        this.verboseParam_ = new BooleanParameter("verbose");
        this.verboseParam_.setPrompt("Display informative comments?");
        this.verboseParam_.setDescription(new String[]{"<p>If true, some INFO reports will be displayed alongside", "any ERROR reports resulting from the parse.", "This may be useful for diagnosis or reassurance.", "</p>"});
        this.verboseParam_.setBooleanDefault(false);
        this.usevolocalsParam_ = new BooleanParameter("uselocals");
        this.usevolocalsParam_.setPrompt("Use local VO schema copies?");
        this.usevolocalsParam_.setDescription(new String[]{"<p>Whether to use local copies of VO schemas where available.", "If true, copies of some IVOA schemas stored within the", "application are used instead of retrieving them from", "their http://www.ivoa.net/ URLs.", "Setting this true is generally faster and more robust", "against network issues, though it may risk retrieving", "out of date copies of the schemas.", "</p>"});
        this.usevolocalsParam_.setBooleanDefault(false);
        this.nsurldfltParam_ = new BooleanParameter("nsurl");
        this.nsurldfltParam_.setPrompt("Use namespace as URL by default?");
        this.nsurldfltParam_.setDescription(new String[]{"<p>Whether to use the namespace URI itself as a", "dereferencable URL to download a schema", "if no location has been supplied from elsewhere.", "For a namespace <code>http://example.com/ns1</code>", "this is like assuming the presence of a", "<code>xsi:schemaLocation=\"http://example.com/ns1 http://example.com/ns1\"</code>", "entry.", "Of course the XSD must be available at the location given", "by the namespace URI for this to work.", "</p>", "<p>Setting this true usually does the right thing,", "but it may risk hitting schema-hosting web servers too hard,", "and maybe it's too lenient on XML documents that don't have", "the right <code>xsi:schemaLocation</code> attributes;", "but <webref url='https://www.w3.org/TR/xmlschema-1/#schema-loc'", ">XMLSchema-1 Sec 4.3.2</webref>", "says it's up to the processor (i.e. this command)", "to figure out where to get schemas from.", "</p>"});
        this.nsurldfltParam_.setBooleanDefault(true);
        this.topelParam_ = new StringParameter("topel");
        this.topelParam_.setUsage("[{<ns-uri>}][<local-name>]");
        this.topelParam_.setPrompt("Local name of required top-level element");
        this.topelParam_.setDescription(new String[]{"<p>Local name of the top-level element expected", "in the parsed document.", "If the actual parsed top-level element has a local name", "differing from this, an error will be reported.", "If no value is specified (the default) no checking is done.", "</p>"});
        this.topelParam_.setNullPermitted(true);
    }

    public String getPurpose() {
        return "Validates against XML Schema";
    }

    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.docParam_, this.schemalocsParam_, this.topelParam_, this.verboseParam_, this.usevolocalsParam_, this.nsurldfltParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        Validator val;
        QName topQName;
        InputStream in = (InputStream)this.docParam_.objectValue(env);
        String topel = this.topelParam_.stringValue(env);
        if (topel == null || topel.trim().length() == 0) {
            topQName = null;
        } else {
            try {
                topQName = QName.valueOf(topel);
            }
            catch (RuntimeException e) {
                throw new ParameterValueException(this.topelParam_, "Not in QName format local{uri}");
            }
        }
        String[] schemalocs = (String[])this.schemalocsParam_.objectValue(env);
        boolean isVerbose = this.verboseParam_.booleanValue(env);
        boolean useVoLocals = this.usevolocalsParam_.booleanValue(env);
        boolean nsUrlDflt = this.nsurldfltParam_.booleanValue(env);
        Recorder recorder = new Recorder(isVerbose, env.getOutputStream());
        LinkedHashMap<String, URL> customSchemaMap = new LinkedHashMap<String, URL>();
        Pattern kvRegex = Pattern.compile("([^=]+)=(.+)");
        if (schemalocs != null) {
            for (String schemaloc : schemalocs) {
                URL url;
                String ns;
                Matcher matcher = kvRegex.matcher(schemaloc);
                if (matcher.matches()) {
                    ns = matcher.group(1);
                    url = URLUtils.makeURL((String)matcher.group(2));
                    if (url == null) {
                        throw new ParameterValueException(this.schemalocsParam_, "Can't interpret as file or URL \"" + matcher.group(2) + "\"");
                    }
                } else {
                    throw new ParameterValueException(this.schemalocsParam_, "Not of form <namespace>=<location>: \"" + schemaloc + "\"");
                }
                customSchemaMap.put(ns, url);
            }
        }
        LinkedHashMap<String, URL> localSchemaMap = new LinkedHashMap<String, URL>();
        localSchemaMap.putAll(IvoaSchemaResolver.W3C_SCHEMA_MAP);
        if (useVoLocals) {
            localSchemaMap.putAll(IvoaSchemaResolver.IVOA_SCHEMA_MAP);
        }
        LinkedHashMap<String, URL> schemaMap = new LinkedHashMap<String, URL>();
        schemaMap.putAll(localSchemaMap);
        schemaMap.putAll(customSchemaMap);
        IvoaSchemaResolver resolver = new IvoaSchemaResolver(schemaMap, nsUrlDflt);
        try {
            val = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema().newValidator();
        }
        catch (SAXException e) {
            throw new ExecutionException("Can't prepare validator", (Throwable)e);
        }
        ValidateErrorHandler errorHandler = new ValidateErrorHandler(recorder);
        ValidateContentHandler contentHandler = new ValidateContentHandler();
        val.setResourceResolver(resolver);
        val.setErrorHandler(errorHandler);
        return () -> {
            block15: {
                try {
                    val.validate(new SAXSource(new InputSource(new BufferedInputStream(in))), new SAXResult(contentHandler));
                }
                catch (IOException e) {
                    recorder.error("Error reading input document: " + e);
                }
                catch (SAXException e) {
                    if (errorHandler.fatalCount_ != 0) break block15;
                    recorder.error("Unexpected document parse error: " + e);
                }
            }
            for (String string : resolver.getResolvedNamespaces()) {
                if (customSchemaMap.containsKey(string)) {
                    recorder.info("Custom schema location: " + string);
                    continue;
                }
                if (localSchemaMap.containsKey(string)) {
                    recorder.info("Local schema location: " + string);
                    continue;
                }
                if (nsUrlDflt) {
                    recorder.info("Schema location from namespace: " + string);
                    continue;
                }
                assert (false) : string;
            }
            for (String string : resolver.getUnresolvedNamespaces()) {
                recorder.info("Default schema location: " + string);
            }
            LinkedHashSet unusedCustoms = new LinkedHashSet(customSchemaMap.keySet());
            unusedCustoms.removeAll(resolver.getResolvedNamespaces());
            for (String ns : unusedCustoms) {
                recorder.warning("Unused custom schema: " + ns);
            }
            recorder.info("Top-level element: " + new QName(contentHandler.topUri_, contentHandler.topLocal_));
            if (topQName != null) {
                String string = topQName.getLocalPart();
                String reqUri = topQName.getNamespaceURI();
                if (string != null && string.trim().length() > 0 && !string.equals(contentHandler.topLocal_)) {
                    recorder.error("Wrong top-level element local name (" + contentHandler.topLocal_ + " != " + string + ")");
                } else if (reqUri != null && reqUri.trim().length() > 0 && !reqUri.equals(contentHandler.topUri_)) {
                    recorder.error("Wrong top-level element URI (" + contentHandler.topUri_ + " != " + reqUri + ")");
                }
            }
            boolean bl = recorder.errorCount_ == 0;
            recorder.info(bl ? "Validation OK" : "Validation failed");
            if (!bl) {
                throw new ExecutionException("Validation failed");
            }
        };
    }

    private static class MessageCounter {
        private final Map<String, Integer> map_;
        private final int nmax_;
        private static final String REPEAT_PREFIX = "[repeated] ";

        MessageCounter(int nmax) {
            this.nmax_ = nmax;
            this.map_ = new HashMap<String, Integer>();
        }

        String getReport(String msg) {
            int count = this.map_.containsKey(msg) ? this.map_.get(msg) : 0;
            this.map_.put(msg, count + 1);
            if (count < this.nmax_) {
                return msg;
            }
            if (count == this.nmax_) {
                return REPEAT_PREFIX + msg;
            }
            return null;
        }

        boolean isRepeat(String report) {
            return report != null && report.startsWith(REPEAT_PREFIX);
        }
    }

    private static class ValidateErrorHandler
    implements ErrorHandler {
        private final Recorder recorder_;
        private final MessageCounter counter_;
        int warningCount_;
        int errorCount_;
        int fatalCount_;

        ValidateErrorHandler(Recorder recorder) {
            this.recorder_ = recorder;
            this.counter_ = new MessageCounter(1);
        }

        @Override
        public void warning(SAXParseException err) {
            ++this.errorCount_;
            this.recordException(err);
        }

        @Override
        public void error(SAXParseException err) {
            ++this.errorCount_;
            this.recordException(err);
        }

        @Override
        public void fatalError(SAXParseException err) {
            ++this.fatalCount_;
            this.recordException(err);
        }

        private void recordException(SAXParseException err) {
            String report;
            String msg = err.getMessage();
            if (msg == null) {
                msg = err.toString();
            }
            if (this.counter_.isRepeat(report = this.counter_.getReport(msg))) {
                this.recorder_.error(report);
            } else if (report != null) {
                StringBuffer sbuf = new StringBuffer();
                int il = err.getLineNumber();
                int ic = err.getColumnNumber();
                if (il > 0) {
                    sbuf.append("(l.").append(il);
                    if (ic > 0) {
                        sbuf.append(", c.").append(ic);
                    }
                    sbuf.append(")");
                }
                sbuf.append(": ").append(msg);
                this.recorder_.error(sbuf.toString());
            }
        }
    }

    private static class ValidateContentHandler
    extends DefaultHandler {
        private boolean isTop_;
        String topUri_;
        String topLocal_;

        private ValidateContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.isTop_) {
                this.isTop_ = true;
                this.topUri_ = uri;
                this.topLocal_ = localName;
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    private static class Recorder {
        private final boolean reportInfo_;
        private final PrintStream out_;
        private final MessageCounter counter_;
        int errorCount_;

        Recorder(boolean reportInfo, PrintStream out) {
            this.out_ = out;
            this.reportInfo_ = reportInfo;
            this.counter_ = new MessageCounter(1);
        }

        public void error(String msg) {
            ++this.errorCount_;
            this.record("ERROR: " + msg);
        }

        public void warning(String msg) {
            this.record("WARNING: " + msg);
        }

        public void info(String msg) {
            if (this.reportInfo_) {
                this.record("INFO: " + msg);
            }
        }

        private void record(String msg) {
            String report = this.counter_.getReport(msg);
            if (report != null) {
                this.out_.println(report);
            }
        }
    }
}

