/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.ttools.votlint.Ancestry;
import uk.ac.starlink.ttools.votlint.ElementHandler;

public class HandlerStack {
    private final List<Item> stack_ = new ArrayList<Item>();
    private int nItem = 0;

    public ElementHandler pop() {
        if (this.nItem > 0) {
            return this.stack_.remove((int)(--this.nItem)).handler_;
        }
        throw new IllegalStateException("Empty stack");
    }

    public void push(ElementHandler handler) {
        if (this.nItem > 0) {
            ++this.stack_.get((int)(this.nItem - 1)).nChild_;
        }
        this.stack_.add(new Item(handler));
        ++this.nItem;
    }

    public ElementHandler top() {
        return this.nItem > 0 ? this.stack_.get((int)(this.nItem - 1)).handler_ : null;
    }

    public Ancestry getAncestry() {
        final int point = this.nItem - 1;
        final Item self = this.stack_.get(point);
        final int siblingIndex = point > 0 ? this.stack_.get((int)(point - 1)).nChild_ - 1 : 0;
        return new Ancestry(){

            @Override
            public int getSiblingIndex() {
                return siblingIndex;
            }

            @Override
            public int getChildCount() {
                return self.nChild_;
            }

            @Override
            public ElementHandler getSelf() {
                this.check();
                return ((Item)((HandlerStack)HandlerStack.this).stack_.get((int)point)).handler_;
            }

            @Override
            public ElementHandler getParent() {
                this.check();
                return point > 0 ? ((Item)((HandlerStack)HandlerStack.this).stack_.get((int)(point - 1))).handler_ : null;
            }

            @Override
            public <H extends ElementHandler> H getAncestor(Class<H> clazz) {
                this.check();
                for (int i = point - 1; i >= 0; --i) {
                    ElementHandler handler = ((Item)((HandlerStack)HandlerStack.this).stack_.get((int)i)).handler_;
                    if (!clazz.isAssignableFrom(handler.getClass())) continue;
                    return (H)((ElementHandler)clazz.cast(handler));
                }
                return null;
            }

            private void check() {
                if (HandlerStack.this.stack_.get(point) != self) {
                    throw new IllegalStateException();
                }
            }
        };
    }

    private static class Item {
        final ElementHandler handler_;
        int nChild_;

        Item(ElementHandler handler) {
            this.handler_ = handler;
        }
    }
}

