/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Locator;
import uk.ac.starlink.ttools.votlint.SaxMessager;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintException;

public class PrintSaxMessager
implements SaxMessager {
    private final PrintStream out_;
    private final boolean debug_;
    private final int maxRepeat_;
    private final Map<VotLintCode, Integer> msgMap_;

    public PrintSaxMessager(PrintStream out, boolean debug, int maxRepeat) {
        this.out_ = out;
        this.debug_ = debug;
        this.maxRepeat_ = maxRepeat;
        this.msgMap_ = new HashMap<VotLintCode, Integer>();
    }

    @Override
    public void reportMessage(SaxMessager.Level level, VotLintCode code, String msg, Locator locator) {
        int repeat = this.msgMap_.containsKey(code) ? this.msgMap_.get(code) : 0;
        this.msgMap_.put(code, repeat + 1);
        if (repeat < this.maxRepeat_) {
            StringBuffer sbuf = new StringBuffer().append((Object)level);
            int il = -1;
            int ic = -1;
            if (locator != null) {
                ic = locator.getColumnNumber();
                il = locator.getLineNumber();
            }
            if (il > 0) {
                sbuf.append(" (l.").append(il);
                if (ic > 0) {
                    sbuf.append(", c.").append(ic);
                }
                sbuf.append(")");
            }
            sbuf.append(": ").append(msg);
            String text = sbuf.toString();
            this.out_.println(text);
            if (this.debug_) {
                VotLintException err = new VotLintException(msg);
                err.fillInStackTrace();
                err.printStackTrace(this.out_);
                this.out_.println();
            }
        } else if (repeat == this.maxRepeat_) {
            String txt = new StringBuffer().append((Object)SaxMessager.Level.INFO).append(" (maxrepeat=").append(this.maxRepeat_).append(") suppressing more messages like \"").append(msg).append("\"").toString();
            this.out_.println(txt);
        }
    }
}

