/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.util.IOUtils;

public class VersionDetector {
    private static final Pattern nsRegex = Pattern.compile(".*VOTable/?v?([0-9a-z_.]+)", 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionString(BufferedInputStream in) throws IOException {
        assert (in.markSupported());
        int[] tryLengths = new int[]{2048, 16384, 262144};
        for (int i = 0; i < tryLengths.length; ++i) {
            byte[] buf;
            int leng = tryLengths[i];
            in.mark(leng);
            try {
                buf = IOUtils.readBytes((InputStream)in, (int)leng);
            }
            finally {
                in.reset();
            }
            Attributes atts = VersionDetector.getVotableAttributes(buf);
            if (atts == null) continue;
            return VersionDetector.getVersionString(atts);
        }
        return null;
    }

    private static String getVersionString(Attributes atts) {
        Matcher matcher;
        String version = VersionDetector.getAttributeValue(atts, "version");
        if (version != null) {
            return version;
        }
        String xmlns = VersionDetector.getAttributeValue(atts, "xmlns");
        if (xmlns != null && (matcher = nsRegex.matcher(xmlns)).matches()) {
            return matcher.group(1);
        }
        int iSchemaLoc = atts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (iSchemaLoc >= 0) {
            String schemaLoc = atts.getValue(iSchemaLoc);
            String[] words = schemaLoc.split("\\s+");
            for (int i = 0; i < words.length; ++i) {
                Matcher matcher2 = nsRegex.matcher(words[i]);
                if (!matcher2.matches()) continue;
                return matcher2.group(1);
            }
        }
        return null;
    }

    private static String getAttributeValue(Attributes atts, String name) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!name.equals(atts.getQName(i)) && !name.equals(atts.getLocalName(i))) continue;
            return atts.getValue(i);
        }
        return null;
    }

    private static Attributes getVotableAttributes(byte[] buf) {
        XMLReader parser;
        StartTagReader vtReader = new StartTagReader("VOTABLE");
        try {
            SAXParserFactory pfact = SAXParserFactory.newInstance();
            pfact.setNamespaceAware(true);
            pfact.setValidating(false);
            parser = pfact.newSAXParser().getXMLReader();
            parser.setContentHandler(vtReader);
            parser.setEntityResolver(vtReader);
            parser.setErrorHandler(vtReader);
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        try {
            parser.parse(new InputSource(new ByteArrayInputStream(buf)));
        }
        catch (DoneException e) {
            return vtReader.getTagAttributes();
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String version = VersionDetector.getVersionString(new BufferedInputStream(System.in));
        System.out.println("version: " + version);
    }

    private static class DoneException
    extends SAXException {
        DoneException() {
            super("Completed parse");
        }
    }

    private static class StartTagReader
    extends DefaultHandler
    implements ContentHandler,
    EntityResolver,
    ErrorHandler {
        private final String tagName_;
        private Attributes tagAtts_;

        StartTagReader(String tagName) {
            this.tagName_ = tagName;
        }

        public Attributes getTagAttributes() {
            return this.tagAtts_;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.tagName_.equals(localName) || this.tagName_.equals(qName)) {
                this.tagAtts_ = atts;
                throw new DoneException();
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw (DoneException)new DoneException().initCause(e);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

