/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Locator;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.ElementRef;
import uk.ac.starlink.ttools.votlint.RefChecker;
import uk.ac.starlink.ttools.votlint.SaxMessager;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.votable.VOTableVersion;

public class VotLintContext {
    private final VOTableVersion version_;
    private final boolean validate_;
    private final SaxMessager messager_;
    private final Map<String, ElementRef> idMap_;
    private final Map<String, UncheckedReference> refMap_;
    private final Map<String, String> namespaceMap_;
    private final Map<String, Collection<ElementRef>> linksMap_;
    private boolean checkUcd_;
    private boolean checkUnit_;
    private Locator locator_;
    private int errCount_;

    public VotLintContext(VOTableVersion version, boolean validate, SaxMessager messager) {
        this.version_ = version;
        this.validate_ = validate;
        this.messager_ = messager;
        this.idMap_ = new LinkedHashMap<String, ElementRef>();
        this.refMap_ = new HashMap<String, UncheckedReference>();
        this.namespaceMap_ = new HashMap<String, String>();
        this.linksMap_ = new LinkedHashMap<String, Collection<ElementRef>>();
        this.checkUcd_ = true;
        this.checkUnit_ = true;
    }

    public VOTableVersion getVersion() {
        return this.version_;
    }

    public boolean isValidating() {
        return this.validate_;
    }

    public boolean isCheckUcd() {
        return this.checkUcd_;
    }

    public void setCheckUcd(boolean checkUcd) {
        this.checkUcd_ = checkUcd;
    }

    public boolean isCheckUnit() {
        return this.checkUnit_;
    }

    public void setCheckUnit(boolean checkUnit) {
        this.checkUnit_ = checkUnit;
    }

    public void setLocator(Locator locator) {
        this.locator_ = locator;
    }

    public Locator getLocator() {
        return this.locator_;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap_;
    }

    public void registerID(String id, ElementHandler handler) {
        if (this.idMap_.containsKey(id)) {
            ElementRef ref = this.idMap_.get(id);
            this.error(new VotLintCode("DID"), "ID " + id + " already defined " + ref);
        } else {
            this.idMap_.put(id, handler.getRef());
            this.linksMap_.put(id, new HashSet());
        }
        if (this.refMap_.containsKey(id)) {
            UncheckedReference unref = this.refMap_.remove(id);
            ElementRef to = this.idMap_.get(id);
            unref.recordLink(to);
        }
    }

    public void registerRef(String id, ElementRef from, RefChecker checker) {
        UncheckedReference unref = new UncheckedReference(id, from, checker);
        if (this.idMap_.containsKey(id)) {
            ElementRef to = this.idMap_.get(id);
            unref.recordLink(to);
        } else {
            this.refMap_.put(id, unref);
        }
    }

    public void reportUncheckedRefs() {
        for (Map.Entry<String, UncheckedReference> entry : this.refMap_.entrySet()) {
            String id = entry.getKey();
            UncheckedReference unref = entry.getValue();
            ElementRef from = unref.from_;
            this.error(new VotLintCode("NFI"), "ID " + id + " referenced from " + from + " never found");
        }
    }

    public void reportUnusedIds() {
        for (Map.Entry<String, Collection<ElementRef>> entry : this.linksMap_.entrySet()) {
            String id = entry.getKey();
            Collection<ElementRef> froms = entry.getValue();
            ElementRef to = this.idMap_.get(id);
            if (froms.size() != 0 || !this.version_.allowTimesys() || !"TIMESYS".equals(to.getName())) continue;
            String msg = new StringBuffer().append(to.getName()).append(" element with ID=\"").append(id).append("\" never referenced").toString();
            this.warning(new VotLintCode("HTI"), msg);
        }
    }

    public void info(VotLintCode code, String msg) {
        this.messager_.reportMessage(SaxMessager.Level.INFO, code, msg, this.locator_);
    }

    public void warning(VotLintCode code, String msg) {
        this.messager_.reportMessage(SaxMessager.Level.WARNING, code, msg, this.locator_);
    }

    public void error(VotLintCode code, String msg) {
        ++this.errCount_;
        this.messager_.reportMessage(SaxMessager.Level.ERROR, code, msg, this.locator_);
    }

    private class UncheckedReference {
        final String id_;
        final ElementRef from_;
        final RefChecker refChecker_;

        UncheckedReference(String id, ElementRef from, RefChecker refChecker) {
            this.id_ = id;
            this.from_ = from;
            this.refChecker_ = refChecker;
        }

        void recordLink(ElementRef to) {
            this.refChecker_.checkLink(VotLintContext.this, this.id_, this.from_, to);
            ((Collection)VotLintContext.this.linksMap_.get(this.id_)).add(this.from_);
        }
    }
}

