/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import cds.healpix.common.math.FastMath;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.SkyPixellator;

public abstract class AbstractSkyMatchEngine
implements MatchEngine {
    private final SkyPixellator pixellator_;
    static final double INVERSE_ARC_SECOND = 206264.80624709636;
    static final double FROM_DEG = Math.PI / 180;
    static final double TO_DEG = 57.29577951308232;
    static final double FROM_ARCSEC = 4.84813681109536E-6;
    static final double TO_ARCSEC = 206264.80624709636;

    protected AbstractSkyMatchEngine(SkyPixellator pixellator, double scale) {
        this.pixellator_ = pixellator;
        this.setScale(scale);
    }

    protected void setScale(double scale) {
        this.pixellator_.setScale(scale);
    }

    protected double getScale() {
        return this.pixellator_.getScale();
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return new DescribedValue[]{this.pixellator_.getTuningParameter()};
    }

    public SkyPixellator getPixellator() {
        return this.pixellator_;
    }

    static double matchScore(double alpha1, double delta1, double alpha2, double delta2, double maxerr) {
        if (Math.abs(delta1 - delta2) > maxerr) {
            return -1.0;
        }
        double sep = AbstractSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2, delta2);
        return sep <= maxerr ? sep * 206264.80624709636 : -1.0;
    }

    static double maxScore(double maxerr) {
        return 206264.80624709636 * maxerr;
    }

    public abstract String toString();

    public static double calculateSeparation(double alpha1, double delta1, double alpha2, double delta2) {
        return AbstractSkyMatchEngine.haversineSeparationFormula(alpha1, delta1, alpha2, delta2);
    }

    public static boolean isSkyPosition(double alpha, double delta) {
        return Double.isFinite(alpha) && delta >= -1.5707963267948966 && delta <= 1.5707963267948966;
    }

    static ValueInfo inDegreeInfo(ValueInfo info) {
        DefaultValueInfo dinfo1 = new DefaultValueInfo(info);
        dinfo1.setUnitString("deg");
        return dinfo1;
    }

    static ValueInfo inArcsecInfo(ValueInfo info) {
        DefaultValueInfo dinfo1 = new DefaultValueInfo(info);
        dinfo1.setUnitString("arcsec");
        return dinfo1;
    }

    static DescribedValue radiansToArcsecParam(final DescribedValue param) {
        return new DescribedValue(AbstractSkyMatchEngine.inArcsecInfo(param.getInfo()), AbstractSkyMatchEngine.multiply(param.getValue(), 206264.80624709636)){

            @Override
            public Object getValue() {
                return AbstractSkyMatchEngine.multiply(param.getValue(), 206264.80624709636);
            }

            @Override
            public void setValue(Object value) {
                param.setValue(AbstractSkyMatchEngine.multiply(value, 4.84813681109536E-6));
            }
        };
    }

    static Double multiply(Object value, double factor) {
        return value instanceof Number ? Double.valueOf(((Number)value).doubleValue() * factor) : null;
    }

    @Deprecated
    private static double cosineSeparationFormula(double alpha1, double delta1, double alpha2, double delta2) {
        return Math.acos(Math.sin(delta1) * Math.sin(delta2) + Math.cos(delta1) * Math.cos(delta2) * Math.cos(alpha1 - alpha2));
    }

    private static double haversineSeparationFormula(double alpha1, double delta1, double alpha2, double delta2) {
        double sa2;
        double sd2 = Math.sin(0.5 * (delta2 - delta1));
        double a = sd2 * sd2 + (sa2 = Math.sin(0.5 * (alpha2 - alpha1))) * sa2 * Math.cos(delta1) * Math.cos(delta2);
        return a < 1.0 ? 2.0 * FastMath.asin(Math.sqrt(a)) : Math.PI;
    }

    static double getNumberValue(Object numobj) {
        return numobj instanceof Number ? ((Number)numobj).doubleValue() : Double.NaN;
    }

    class SkyScaleParameter
    extends DescribedValue {
        SkyScaleParameter(ValueInfo info) {
            super(info);
        }

        @Override
        public Object getValue() {
            return AbstractSkyMatchEngine.this.getScale();
        }

        @Override
        public void setValue(Object value) {
            AbstractSkyMatchEngine.this.setScale(AbstractSkyMatchEngine.getNumberValue(value));
        }
    }
}

