/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.HTMrangeIterator;
import edu.jhu.htm.geometry.Circle;
import java.util.ArrayList;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.join.FixedRadiusConePixer;
import uk.ac.starlink.table.join.SkyPixellator;
import uk.ac.starlink.table.join.VariableRadiusConePixer;

public class HtmSkyPixellator
implements SkyPixellator {
    private final DescribedValue levelParam_ = new LevelParameter();
    private double scale_;
    private int level_ = -1;
    private static final double DEFAULT_SCALE_FACTOR = 8.0;
    private static DefaultValueInfo LEVEL_INFO = new DefaultValueInfo("HTM Level", Integer.class, "Controls sky pixel size. Legal range 0 (90deg) - 24 (.01\").");

    @Override
    public void setScale(double scale) {
        this.scale_ = scale;
    }

    @Override
    public double getScale() {
        return this.scale_;
    }

    @Override
    public DescribedValue getTuningParameter() {
        return this.levelParam_;
    }

    @Override
    public Supplier<VariableRadiusConePixer> createVariableRadiusPixerFactory() {
        int level = this.getLevel();
        final HTMindexImp htm = new HTMindexImp(level, Math.min(level, 2));
        return () -> new VariableRadiusConePixer(){

            public Long[] getPixels(double alpha, double delta, double radius) {
                return HtmSkyPixellator.calculateConePixels(htm, alpha, delta, radius);
            }
        };
    }

    @Override
    public Supplier<FixedRadiusConePixer> createFixedRadiusPixerFactory(final double radius) {
        int level = this.getLevel();
        final HTMindexImp htm = new HTMindexImp(level, Math.min(level, 2));
        return () -> new FixedRadiusConePixer(){

            public Long[] getPixels(double alpha, double delta) {
                return HtmSkyPixellator.calculateConePixels(htm, alpha, delta, radius);
            }
        };
    }

    public void setLevel(int level) {
        if (level < -1 || level > 24) {
            throw new IllegalArgumentException("HTM level " + level + " out of range 0..24");
        }
        this.level_ = level;
    }

    public int getLevel() {
        if (this.level_ >= 0) {
            return this.level_;
        }
        double scale = this.getScale();
        return scale > 0.0 ? this.calculateDefaultLevel(scale) : -1;
    }

    public int calculateDefaultLevel(double scale) {
        double pixelSize = 8.0 * scale;
        double pixelSizeDeg = Math.toDegrees(pixelSize);
        int lev = 5;
        for (double htmwidth = 2.8125; htmwidth > pixelSizeDeg && lev < 25; htmwidth /= 2.0, ++lev) {
        }
        return lev;
    }

    private static Long[] calculateConePixels(HTMindexImp htm, double alpha, double delta, double radius) {
        double arcminRadius = Math.toDegrees(radius) * 60.0;
        Circle zone = new Circle(alpha, delta, arcminRadius);
        Domain domain = zone.getDomain();
        domain.setOlevel(htm.maxlevel_);
        HTMrange range = new HTMrange();
        domain.intersect(htm, range, false);
        ArrayList binList = new ArrayList();
        try {
            HTMrangeIterator it = new HTMrangeIterator(range, false);
            while (it.hasNext()) {
                binList.add(it.next());
            }
        }
        catch (HTMException e) {
            throw new RuntimeException("Uh-oh", e);
        }
        return binList.toArray(new Long[0]);
    }

    static {
        LEVEL_INFO.setNullable(true);
    }

    private class LevelParameter
    extends DescribedValue {
        LevelParameter() {
            super(LEVEL_INFO);
        }

        @Override
        public Object getValue() {
            int level = HtmSkyPixellator.this.getLevel();
            return level >= 0 ? Integer.valueOf(level) : null;
        }

        @Override
        public void setValue(Object value) {
            HtmSkyPixellator.this.setLevel(value == null ? -1 : (Integer)value);
        }
    }
}

