/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.CuboidCoverage;
import uk.ac.starlink.table.join.MatchKit;

public class IsotropicCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final DescribedValue[] matchParams_;
    private static final ValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Maximum Cartesian separation for match");
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Spatial distance between matched points");

    public IsotropicCartesianMatchEngine(int ndim, double err, boolean normaliseScores) {
        super(ndim);
        this.ndim_ = ndim;
        this.matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERR_INFO)};
        this.setIsotropicScale(err);
    }

    public void setError(double err) {
        this.setIsotropicScale(err);
    }

    public double getError() {
        return this.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double getScoreScale() {
        return this.getError();
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<AbstractCartesianMatchEngine.CartesianBinner> binnerFact = this.createBinnerFactory();
        double error = this.getError();
        return () -> new IsotropicMatchKit(error, (AbstractCartesianMatchEngine.CartesianBinner)binnerFact.get());
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double err = this.getError();
        return () -> CuboidCoverage.createFixedCartesianCoverage(this.ndim_, err);
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cartesian";
    }

    private static class IsotropicMatchKit
    implements MatchKit {
        final double error_;
        final AbstractCartesianMatchEngine.CartesianBinner binner_;
        final int ndim_;
        final double[] work0_;
        final double[] work1_;
        final double[] work2_;

        IsotropicMatchKit(double error, AbstractCartesianMatchEngine.CartesianBinner binner) {
            this.error_ = error;
            this.binner_ = binner;
            this.ndim_ = binner.getNdim();
            this.work0_ = new double[this.ndim_];
            this.work1_ = new double[this.ndim_];
            this.work2_ = new double[this.ndim_];
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            this.binner_.toCoords(tuple1, this.work1_);
            this.binner_.toCoords(tuple2, this.work2_);
            return AbstractCartesianMatchEngine.matchScore(this.ndim_, this.work1_, this.work2_, this.error_);
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            this.binner_.toCoords(tuple, this.work0_);
            return this.binner_.getRadiusBins(this.work0_, this.error_ * 0.5);
        }
    }
}

