/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public abstract class Match1Type {
    public abstract LinkSet processLinks(LinkSet var1);

    public abstract StarTable createMatchTable(StarTable var1, Collection<RowLink> var2);

    public static Match1Type createIdentifyType() {
        final JoinFixAction inFix = JoinFixAction.makeRenameDuplicatesAction("_old");
        final JoinFixAction grpFix = JoinFixAction.NO_ACTION;
        return new Match1Type(){

            @Override
            public LinkSet processLinks(LinkSet rowLinks) {
                return rowLinks;
            }

            @Override
            public StarTable createMatchTable(StarTable inTable, Collection<RowLink> rowLinks) {
                return Match1Type.createIdentifyMatch(inTable, rowLinks, inFix, grpFix);
            }
        };
    }

    public static Match1Type createEliminateMatchesType(final int retainCount) {
        return new Match1Type(){

            @Override
            public LinkSet processLinks(LinkSet rowLinks) {
                return rowLinks;
            }

            @Override
            public StarTable createMatchTable(StarTable inTable, Collection<RowLink> rowLinks) {
                return Match1Type.createDeduplicateMatch(inTable, rowLinks, retainCount);
            }
        };
    }

    public static Match1Type createWideType(final int grpSize) {
        final JoinFixAction[] fixActs = new JoinFixAction[grpSize];
        for (int i = 0; i < grpSize; ++i) {
            fixActs[i] = JoinFixAction.makeRenameDuplicatesAction("_" + (i + 1));
        }
        return new Match1Type(){

            @Override
            public LinkSet processLinks(LinkSet links) {
                Iterator<RowLink> it = links.iterator();
                while (it.hasNext()) {
                    RowLink link = it.next();
                    int nref = link.size();
                    int n0ref = 0;
                    for (int i = 0; i < nref; ++i) {
                        RowRef ref = link.getRef(i);
                        if (ref.getTableIndex() != 0) continue;
                        ++n0ref;
                    }
                    if (n0ref == grpSize) continue;
                    it.remove();
                }
                return links;
            }

            @Override
            public StarTable createMatchTable(StarTable inTable, Collection<RowLink> rowLinks) {
                return Match1Type.makeParallelMatchTable(inTable, 0, rowLinks, grpSize, grpSize, grpSize, fixActs);
            }
        };
    }

    private static StarTable createIdentifyMatch(StarTable inTable, Collection<RowLink> rowLinks, JoinFixAction inFix, JoinFixAction grpFix) {
        long nrow = inTable.getRowCount();
        StarTable grpTable = MatchStarTables.makeInternalMatchTable(0, rowLinks, nrow);
        return new JoinStarTable(new StarTable[]{inTable, grpTable}, new JoinFixAction[]{inFix, grpFix});
    }

    private static StarTable createDeduplicateMatch(StarTable inTable, Collection<RowLink> rowLinks, int retainCount) {
        int nrow = Tables.checkedLongToInt(inTable.getRowCount());
        BitSet bits = new BitSet(nrow);
        bits.set(0, nrow);
        for (RowLink link : rowLinks) {
            int nref = link.size();
            for (int i = retainCount; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != 0) {
                    throw new IllegalArgumentException("Intra-table LinkSet has links from multiple tables");
                }
                bits.clear(Tables.checkedLongToInt(ref.getRowIndex()));
            }
        }
        int nbit = bits.cardinality();
        long[] rowMap = new long[nbit];
        int i = 0;
        int ipos = bits.nextSetBit(0);
        while (ipos >= 0) {
            rowMap[i++] = ipos;
            ipos = bits.nextSetBit(ipos + 1);
        }
        assert (i == nbit);
        return new RowPermutedStarTable(inTable, rowMap);
    }

    private static StarTable makeParallelMatchTable(StarTable table, int iTable, Collection<RowLink> links, int width, int minSize, int maxSize, JoinFixAction[] fixActs) {
        String name;
        int nrow = links.size();
        long[][] rowIndices = new long[width][];
        for (int i = 0; i < width; ++i) {
            rowIndices[i] = new long[nrow];
            Arrays.fill(rowIndices[i], -1L);
        }
        int iLink = 0;
        for (RowLink link : links) {
            int nref = link.size();
            int refPos = 0;
            for (int i = 0; i < nref && refPos < width; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                rowIndices[refPos++][iLink] = ref.getRowIndex();
            }
            assert (refPos >= minSize && refPos <= maxSize);
            ++iLink;
        }
        assert (iLink == nrow);
        StarTable[] subTables = new StarTable[width];
        for (int i = 0; i < width; ++i) {
            subTables[i] = new RowPermutedStarTable(table, rowIndices[i]);
        }
        boolean[] hasBlankRows = new boolean[width];
        for (int iw = 0; iw < width; ++iw) {
            for (int ir = 0; ir < nrow; ++ir) {
                hasBlankRows[iw] = hasBlankRows[iw] || rowIndices[iw][ir] < 0L;
            }
        }
        int ncol = table.getColumnCount();
        int xNcol = ncol * width;
        final ColumnInfo[] colinfos = new ColumnInfo[xNcol];
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo cinfo = table.getColumnInfo(ic);
            for (int iw = 0; iw < width; ++iw) {
                ColumnInfo ci = new ColumnInfo(cinfo);
                ci.setName(ci.getName() + "_" + (iw + 1));
                if (hasBlankRows[iw]) {
                    ci.setNullable(true);
                }
                colinfos[ic + iw * ncol] = ci;
            }
        }
        JoinStarTable joined = new JoinStarTable(subTables, fixActs){

            @Override
            public ColumnInfo getColumnInfo(int icol) {
                return colinfos[icol];
            }
        };
        switch (width) {
            case 2: {
                name = "pairs";
                break;
            }
            case 3: {
                name = "triples";
                break;
            }
            case 4: {
                name = "quads";
                break;
            }
            default: {
                name = "setsOf" + width;
            }
        }
        joined.setName(name);
        return joined;
    }
}

