/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import uk.ac.starlink.table.join.RowLink1;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowLinkN;
import uk.ac.starlink.table.join.RowRef;

public abstract class RowLink
implements Comparable<RowLink> {
    public abstract int size();

    public abstract RowRef getRef(int var1);

    public boolean equals(Object o) {
        if (o instanceof RowLink) {
            RowLink other = (RowLink)o;
            int nref = this.size();
            if (nref == other.size()) {
                for (int i = 0; i < nref; ++i) {
                    if (this.getRef(i).equals(other.getRef(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int nref = this.size();
        int result = 37;
        for (int i = 0; i < nref; ++i) {
            result = 23 * result + this.getRef(i).hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(RowLink other) {
        boolean hasMatchingTables;
        int nref = this.size();
        if (other.size() == nref) {
            boolean matching = true;
            for (int i = 0; i < nref; ++i) {
                matching = matching && this.getRef(i).getTableIndex() == other.getRef(i).getTableIndex();
            }
            hasMatchingTables = matching;
        } else {
            hasMatchingTables = false;
        }
        if (hasMatchingTables) {
            for (int i = 0; i < nref; ++i) {
                long ir1;
                long ir0 = this.getRef(i).getRowIndex();
                if (ir0 < (ir1 = other.getRef(i).getRowIndex())) {
                    return -1;
                }
                if (ir0 <= ir1) continue;
                return 1;
            }
            return Integer.compare(this.hashCode(), other.hashCode());
        }
        int nTable = Math.max(other.getRef(other.size() - 1).getTableIndex() + 1, this.getRef(this.size() - 1).getTableIndex() + 1);
        long[] thisRowIndices = RowLink.getRowIndices(this, nTable);
        long[] otherRowIndices = RowLink.getRowIndices(other, nTable);
        for (int i = 0; i < nTable; ++i) {
            if (thisRowIndices[i] < otherRowIndices[i]) {
                return -1;
            }
            if (thisRowIndices[i] <= otherRowIndices[i]) continue;
            return 1;
        }
        return Integer.compare(this.hashCode(), other.hashCode());
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.getRef(i).toString());
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    public static RowLink createLink(Collection<RowRef> refs) {
        switch (refs.size()) {
            case 1: {
                return new RowLink1(refs.iterator().next());
            }
            case 2: {
                Iterator<RowRef> it2 = refs.iterator();
                RowRef ref1 = it2.next();
                RowRef ref2 = it2.next();
                assert (!it2.hasNext());
                return new RowLink2(ref1, ref2);
            }
        }
        return new RowLinkN(refs);
    }

    private static boolean hasMatchingTables(RowLink link1, RowLink link2) {
        int n = link1.size();
        if (link2.size() == n) {
            for (int i = 0; i < n; ++i) {
                if (link1.getRef(i).getTableIndex() == link2.getRef(i).getTableIndex()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static long[] getRowIndices(RowLink link, int nTable) {
        long[] rowIndices = new long[nTable];
        Arrays.fill(rowIndices, Long.MAX_VALUE);
        int nref = link.size();
        for (int i = 0; i < nref; ++i) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            long iRow = ref.getRowIndex();
            if (iRow >= rowIndices[iTable]) continue;
            rowIndices[iTable] = iRow;
        }
        return rowIndices;
    }
}

