/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusCone4XMatch;
import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.join.BitsetMask;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.HealpixMask;

public abstract class SkyCoverage
implements Coverage {
    private final HealpixMask mask_;
    private final int txtOrder_;

    protected SkyCoverage(HealpixMask mask) {
        this.mask_ = mask;
        this.txtOrder_ = 1;
    }

    protected SkyCoverage() {
        this(new BitsetMask(6));
    }

    public HealpixMask getMask() {
        return this.mask_;
    }

    @Override
    public boolean isEmpty() {
        return this.mask_.isEmpty();
    }

    @Override
    public void intersection(Coverage other) {
        this.mask_.intersection(((SkyCoverage)other).mask_);
    }

    @Override
    public void union(Coverage other) {
        this.mask_.union(((SkyCoverage)other).mask_);
    }

    @Override
    public String coverageText() {
        double fraction = this.mask_.getSkyFraction();
        if (fraction == 0.0) {
            return "none";
        }
        if (fraction == 1.0) {
            return "All sky";
        }
        return new StringBuffer().append((float)fraction).append(" of sky (HEALPix ").append(this.txtOrder_).append(": ").append(SkyCoverage.hexMask(this.txtOrder_, this.mask_.createPixelTester())).append(")").toString();
    }

    public static SkyCoverage createFixedErrorCoverage(double errRad, final TupleDecoder posDecoder) {
        int maxDepth = Healpix.getBestStartingDepth(errRad);
        final int depth = Math.max(0, maxDepth - 1);
        final HealpixNested healpixNested = Healpix.getNested(depth);
        final HealpixNestedFixedRadiusCone4XMatch coneComputer = healpixNested.newConeComputer4Xmatch(errRad);
        return new SkyCoverage(){
            final HealpixMask mask_ = this.getMask();
            final double[] lonlat_ = new double[2];
            final long[] cells_ = new long[9];

            @Override
            public void extend(Object[] tuple) {
                if (posDecoder.decodeTuple(tuple, this.lonlat_)) {
                    int ncell = coneComputer.overlappingCells(this.lonlat_[0], this.lonlat_[1], this.cells_);
                    for (int icell = 0; icell < ncell; ++icell) {
                        this.mask_.addPixel(depth, this.cells_[icell]);
                    }
                }
            }

            @Override
            public Supplier<Predicate<Object[]>> createTestFactory() {
                HealpixMask.PixelTester pixTester = this.mask_.createPixelTester();
                return () -> {
                    double[] lonlat = new double[2];
                    HashComputer hashComputer = healpixNested.newHashComputer();
                    return tuple -> {
                        if (posDecoder.decodeTuple((Object[])tuple, lonlat)) {
                            long hash = hashComputer.hash(lonlat[0], lonlat[1]);
                            return pixTester.containsPixel(depth, hash);
                        }
                        return false;
                    };
                };
            }
        };
    }

    public static SkyCoverage createVariableErrorCoverage(double scaleRad, final TupleDecoder coneDecoder) {
        int depth = Healpix.getBestStartingDepth(scaleRad);
        final HealpixNested healpixNested = Healpix.getNested(depth);
        return new SkyCoverage(){
            final HealpixMask mask_ = this.getMask();
            final double[] lonLatErr_ = new double[3];

            @Override
            public void extend(Object[] tuple) {
                HealpixNestedBMOC bmoc = this.calculateBmoc(tuple, this.lonLatErr_);
                if (bmoc != null) {
                    for (HealpixNestedBMOC.CurrentValueAccessor acc : bmoc) {
                        this.mask_.addPixel(acc.getDepth(), acc.getHash());
                    }
                }
            }

            @Override
            public Supplier<Predicate<Object[]>> createTestFactory() {
                HealpixMask.PixelTester pixTester = this.mask_.createPixelTester();
                return () -> {
                    double[] lonLatErr = new double[3];
                    return tuple -> {
                        HealpixNestedBMOC bmoc = this.calculateBmoc((Object[])tuple, lonLatErr);
                        if (bmoc != null) {
                            for (HealpixNestedBMOC.CurrentValueAccessor acc : bmoc) {
                                if (!pixTester.containsPixel(acc.getDepth(), acc.getHash())) continue;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    };
                };
            }

            private HealpixNestedBMOC calculateBmoc(Object[] tuple, double[] lonLatErr) {
                if (coneDecoder.decodeTuple(tuple, lonLatErr)) {
                    double lon = lonLatErr[0];
                    double lat = lonLatErr[1];
                    double err = lonLatErr[2];
                    return healpixNested.newConeComputerApprox(err >= 0.0 ? err : 0.0).overlappingCells(lon, lat);
                }
                return null;
            }
        };
    }

    private static String hexMask(int order, HealpixMask.PixelTester tester) {
        long nbit = 12 << 2 * order;
        StringBuffer sbuf = new StringBuffer(3 + (int)(nbit / 4L));
        for (long i = 0L; i < nbit; i += 4L) {
            if (i > 0L && i % (nbit / 3L) == 0L) {
                sbuf.append(' ');
            }
            int digit = (tester.containsPixel(order, i + 0L) ? 8 : 0) + (tester.containsPixel(order, i + 1L) ? 4 : 0) + (tester.containsPixel(order, i + 2L) ? 2 : 0) + (tester.containsPixel(order, i + 3L) ? 1 : 0);
            sbuf.append(Integer.toHexString(digit));
        }
        return sbuf.toString();
    }

    @FunctionalInterface
    public static interface TupleDecoder {
        public boolean decodeTuple(Object[] var1, double[] var2);
    }
}

