/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.starlink.table.join.Profiler;
import uk.ac.starlink.table.join.ProgressIndicator;

public class TextProgressIndicator
implements ProgressIndicator {
    private final PrintStream out_;
    private final Profiler profiler_;
    private final int fullWidth_;
    private final AtomicInteger dotCount_;
    private int blankWidth_;
    private long lastUsedMem_;

    TextProgressIndicator(PrintStream out, Profiler profiler) {
        this.out_ = out;
        this.profiler_ = profiler;
        this.fullWidth_ = 78;
        this.dotCount_ = new AtomicInteger();
    }

    @Override
    public void startStage(String stage) {
        this.out_.print(stage);
        this.blankWidth_ = this.fullWidth_ - stage.length();
        this.dotCount_.set(0);
        if (this.profiler_ != null) {
            this.profiler_.reset();
        }
    }

    @Override
    public void setLevel(double level) {
        int oldDots;
        level = Math.max(Math.min(level, 1.0), 0.0);
        int newDots = (int)Math.round(level * (double)this.blankWidth_);
        for (int i = oldDots = this.dotCount_.getAndSet(newDots); i < newDots; ++i) {
            this.out_.print(".");
        }
    }

    @Override
    public void endStage() {
        this.out_.println();
        if (this.profiler_ != null) {
            this.out_.println(this.profiler_.report());
        }
    }

    @Override
    public void logMessage(String msg) {
        this.out_.println(msg);
    }

    public static TextProgressIndicator createInstance(PrintStream out, boolean hasTime, boolean hasMem) {
        Profiler profiler = hasTime || hasMem ? new Profiler(hasTime, hasMem) : null;
        return new TextProgressIndicator(out, profiler);
    }
}

