/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import uk.ac.starlink.astrogrid.AcrConnection;
import uk.ac.starlink.util.DataSource;

public class AcrDataSource
extends DataSource {
    private final AcrConnection connection_;
    private final String uri_;

    public AcrDataSource(AcrConnection connection, String uri) {
        this.connection_ = connection;
        this.uri_ = uri;
    }

    public long getLength() {
        try {
            Map info = (Map)this.connection_.execute("astrogrid.myspace.getNodeInformation", new Object[]{this.uri_});
            return ((Number)info.get("size")).longValue();
        }
        catch (Exception e) {
            return super.getLength();
        }
    }

    public InputStream getRawInputStream() throws IOException {
        String url = (String)this.connection_.execute("astrogrid.myspace.getReadContentURL", new Object[]{this.uri_});
        return new BufferedInputStream(new URL(url).openStream());
    }
}

