/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid.protocols.ivo;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import uk.ac.starlink.astrogrid.AcrConnection;
import uk.ac.starlink.astrogrid.AcrConnector;
import uk.ac.starlink.astrogrid.protocols.ivo.IvoURLConnection;

public class Handler
extends URLStreamHandler {
    private final AcrConnector connector_ = new AcrConnector();
    private AcrConnection connection_;

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new IvoURLConnection(this.getConnection(), url);
    }

    @Override
    protected void parseURL(URL url, String spec, int start, int limit) {
        super.parseURL(url, spec, start, limit);
        String us = url.toString();
        assert (us.equals(url.toString()));
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String authority = url.getAuthority();
        String userInfo = url.getUserInfo();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        if (ref != null && ref.length() > 0) {
            path = path + "#" + ref;
            ref = null;
        }
        this.setURL(url, protocol, host, port, authority, userInfo, path, query, ref);
        assert (us.equals(url.toString()));
    }

    private AcrConnection getConnection() throws IOException {
        if (this.connection_ == null || !this.connection_.isConnected()) {
            this.connection_ = (AcrConnection)this.connector_.logIn();
        }
        return this.connection_;
    }
}

