/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.util.DataBufferedInputStream;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FlagIO;

class BinaryRowSequence
implements RowSequence {
    private final DataBufferedInputStream dataIn_;
    private final int ncol_;
    private final RowReader rowReader_;
    private Object[] row_;

    public BinaryRowSequence(final Decoder[] decoders, InputStream in, String encoding, boolean isBinary2) throws IOException {
        this.ncol_ = decoders.length;
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        } else if ("base64".equals(encoding)) {
            in = Base64.getMimeDecoder().wrap(in);
        }
        this.dataIn_ = new DataBufferedInputStream(in);
        this.rowReader_ = this.ncol_ == 0 ? new RowReader(){

            @Override
            public void readRow(Object[] row) throws IOException {
                throw new EOFException("No columns");
            }
        } : (isBinary2 ? new RowReader(){
            final boolean[] nullFlags;
            {
                this.nullFlags = new boolean[BinaryRowSequence.this.ncol_];
            }

            @Override
            public void readRow(Object[] row) throws IOException {
                FlagIO.readFlags(BinaryRowSequence.this.dataIn_, this.nullFlags);
                for (int icol = 0; icol < BinaryRowSequence.this.ncol_; ++icol) {
                    Object cell;
                    Decoder decoder = decoders[icol];
                    if (this.nullFlags[icol]) {
                        decoder.skipStream(BinaryRowSequence.this.dataIn_);
                        cell = null;
                    } else {
                        cell = decoder.decodeStream(BinaryRowSequence.this.dataIn_);
                    }
                    row[icol] = cell;
                }
            }
        } : new RowReader(){

            @Override
            public void readRow(Object[] row) throws IOException {
                for (int icol = 0; icol < BinaryRowSequence.this.ncol_; ++icol) {
                    row[icol] = decoders[icol].decodeStream(BinaryRowSequence.this.dataIn_);
                }
            }
        });
    }

    @Override
    public boolean next() throws IOException {
        try {
            Object[] row = new Object[this.ncol_];
            this.rowReader_.readRow(row);
            this.row_ = row;
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    @Override
    public Object[] getRow() {
        if (this.row_ != null) {
            return this.row_;
        }
        throw new IllegalStateException("No next() yet");
    }

    @Override
    public Object getCell(int icol) {
        if (this.row_ != null) {
            return this.row_[icol];
        }
        throw new IllegalStateException("No next() yet");
    }

    @Override
    public void close() throws IOException {
        this.dataIn_.close();
    }

    private static interface RowReader {
        public void readRow(Object[] var1) throws IOException;
    }
}

