/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOTableDOMBuilder;

public class VOElementFactory {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    private StoragePolicy storagePolicy;
    private Boolean strict;
    public static final String STRICT_PROPERTY = "votable.strict";
    public static boolean STRICT_DEFAULT = true;

    public VOElementFactory(StoragePolicy policy) {
        this.setStoragePolicy(policy);
    }

    public VOElementFactory() {
        this(StoragePolicy.getDefaultPolicy());
    }

    public StoragePolicy getStoragePolicy() {
        return this.storagePolicy;
    }

    public void setStoragePolicy(StoragePolicy policy) {
        this.storagePolicy = policy;
    }

    public VOElement makeVOElement(Element el, String systemId) {
        if (el instanceof VOElement) {
            return (VOElement)el;
        }
        VODocument doc = new VODocument(el.getOwnerDocument(), systemId, this.isStrict());
        doc.setStoragePolicy(this.getStoragePolicy());
        return (VOElement)doc.getDelegator(el);
    }

    public VOElement makeVOElement(Document doc, String systemId) {
        if (doc instanceof VODocument) {
            return (VOElement)doc.getDocumentElement();
        }
        VODocument vodoc = new VODocument(doc, systemId, this.isStrict());
        vodoc.setStoragePolicy(this.getStoragePolicy());
        return (VOElement)vodoc.getDocumentElement();
    }

    public VOElement makeVOElement(DOMSource dsrc) {
        String systemId = dsrc.getSystemId();
        Node node = dsrc.getNode();
        if (node instanceof VOElement) {
            return (VOElement)node;
        }
        if (node instanceof VODocument) {
            return (VOElement)((VODocument)node).getDocumentElement();
        }
        if (node.getOwnerDocument() instanceof VODocument) {
            return (VOElement)((VODocument)node.getOwnerDocument()).getDocumentElement();
        }
        if (node instanceof Element) {
            return this.makeVOElement((Element)node, systemId);
        }
        if (node instanceof Document) {
            return this.makeVOElement(((Document)node).getDocumentElement(), systemId);
        }
        return this.makeVOElement(node.getOwnerDocument().getDocumentElement(), systemId);
    }

    public VOElement makeVOElement(Source xsrc) throws SAXException, IOException {
        return this.makeVOElement(this.transformToDOM(xsrc, false));
    }

    public VOElement makeVOElement(InputStream strm, String systemId) throws SAXException, IOException {
        InputSource insrc = new InputSource(strm);
        insrc.setSystemId(systemId);
        SAXSource saxsrc = new SAXSource(insrc);
        saxsrc.setSystemId(systemId);
        return this.makeVOElement(saxsrc);
    }

    public VOElement makeVOElement(String uri) throws SAXException, IOException {
        URL httpUrl;
        InputSource inSrc = new InputSource(uri);
        if (uri.toLowerCase().startsWith("http")) {
            try {
                httpUrl = new URI(uri).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                httpUrl = null;
            }
        } else {
            httpUrl = null;
        }
        if (httpUrl != null) {
            URLConnection conn = AuthManager.getInstance().connect(httpUrl);
            inSrc.setByteStream(conn.getInputStream());
        }
        SAXSource saxsrc = new SAXSource(inSrc);
        saxsrc.setSystemId(uri);
        return this.makeVOElement(saxsrc);
    }

    public VOElement makeVOElement(URL url) throws SAXException, IOException {
        return this.makeVOElement(url.toExternalForm());
    }

    public VOElement makeVOElement(File file) throws SAXException, IOException {
        return this.makeVOElement(file.toURI().toString());
    }

    public VOElement makeVOElement(DataSource datsrc) throws SAXException, IOException {
        return this.makeVOElement(datsrc.getHybridInputStream(), datsrc.getSystemId());
    }

    public DOMSource transformToDOM(Source xsrc, boolean validate) throws SAXException, IOException {
        InputSource insource;
        String systemId = xsrc.getSystemId();
        if (xsrc instanceof DOMSource) {
            Node node = ((DOMSource)xsrc).getNode();
            if (node instanceof VODocument || node.getOwnerDocument() instanceof VODocument) {
                return (DOMSource)xsrc;
            }
            Document baseDoc = node instanceof Document ? (Document)node : node.getOwnerDocument();
            VODocument vodoc = new VODocument(baseDoc, systemId, this.isStrict());
            vodoc.setStoragePolicy(this.getStoragePolicy());
            return new DOMSource(vodoc.getDelegator(node), systemId);
        }
        XMLReader parser = null;
        if (xsrc instanceof SAXSource) {
            SAXSource saxsrc = (SAXSource)xsrc;
            insource = saxsrc.getInputSource();
            insource.setSystemId(systemId);
            parser = saxsrc.getXMLReader();
        } else if (xsrc instanceof StreamSource) {
            StreamSource strmsrc = (StreamSource)xsrc;
            if (strmsrc.getInputStream() != null) {
                insource = new InputSource(strmsrc.getInputStream());
                insource.setSystemId(systemId);
            } else if (strmsrc.getReader() != null) {
                insource = new InputSource(strmsrc.getReader());
                insource.setSystemId(systemId);
            } else {
                insource = new InputSource(strmsrc.getSystemId());
            }
        } else {
            try {
                Node node = new SourceReader().getDOM(xsrc);
                return this.transformToDOM(new DOMSource(node, systemId), validate);
            }
            catch (TransformerException e) {
                throw (SAXException)new SAXException(e.getMessage(), e).initCause(e);
            }
        }
        if (parser == null) {
            parser = VOElementFactory.makeParser(validate);
        }
        Document node = this.parseToDOM(parser, insource);
        return new DOMSource(node, systemId);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        if (this.strict == null) {
            this.strict = VOElementFactory.isStrictByDefault();
        }
        return this.strict;
    }

    public static boolean isStrictByDefault() {
        try {
            String strictVal = System.getProperty(STRICT_PROPERTY);
            return strictVal == null ? STRICT_DEFAULT : Boolean.valueOf(strictVal);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static XMLReader makeParser(final boolean validating) throws SAXException {
        SAXParser sparser;
        SAXParserFactory spfact = SAXParserFactory.newInstance();
        spfact.setValidating(validating);
        Namespacing.getInstance().configureSAXParserFactory(spfact);
        try {
            sparser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            logger.config("Parser configuration failed first time: " + e);
            try {
                sparser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e2) {
                throw (SAXException)new SAXException(e2).initCause(e);
            }
        }
        XMLReader parser = sparser.getXMLReader();
        parser.setEntityResolver(new StarEntityResolver(parser.getEntityResolver()));
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                if (validating) {
                    throw e;
                }
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
            }
        });
        return parser;
    }

    private Document parseToDOM(XMLReader parser, InputSource insource) throws IOException, SAXException {
        VOTableDOMBuilder db = new VOTableDOMBuilder(this.getStoragePolicy(), this.isStrict());
        parser.setContentHandler(db);
        try {
            parser.parse(insource);
        }
        catch (SAXException e) {
            throw VOElementFactory.fixStackTrace(e);
        }
        return db.getDocument();
    }

    static SAXException fixStackTrace(SAXException e) {
        if (e.getException() != null && e.getCause() == null) {
            e.initCause(e.getException());
        }
        return e;
    }
}

