/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

@Deprecated
public abstract class VOTableFitsTableWriter
extends AbstractFitsTableWriter {
    private VOTableVersion votVersion_;
    private static String XML_ENCODING = "UTF-8";
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    protected VOTableFitsTableWriter(String formatName) {
        super(formatName);
        this.setAllowSignedByte(false);
        this.votVersion_ = VOTableVersion.getDefaultVersion();
    }

    @Override
    public void setAllowSignedByte(boolean allowSignedByte) {
        if (allowSignedByte) {
            throw new IllegalArgumentException("Not recommended for fits-plus");
        }
        super.setAllowSignedByte(allowSignedByte);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        ArrayList<StarTable> tableList = new ArrayList<StarTable>();
        while ((table = tableSeq.nextTable()) != null) {
            tableList.add(table);
        }
        StarTable[] tables = tableList.toArray(new StarTable[0]);
        int ntable = tables.length;
        FitsTableSerializer[] fitsers = new FitsTableSerializer[ntable];
        for (int i = 0; i < ntable; ++i) {
            fitsers[i] = this.createSerializer(tables[i]);
        }
        DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
        out = null;
        this.writePrimaryHDU(tables, fitsers, dout);
        for (int i = 0; i < ntable; ++i) {
            this.writeTableHDU(tables[i], fitsers[i], dout);
        }
        dout.flush();
    }

    public void setVotableVersion(VOTableVersion votVersion) {
        this.votVersion_ = votVersion;
    }

    private void writePrimaryHDU(StarTable[] tables, FitsTableSerializer[] fitsers, OutputStream out) throws IOException {
        IOException thrown = null;
        try {
            this.writeVOTablePrimary(tables, fitsers, out);
            return;
        }
        catch (IOException e) {
            thrown = e;
            assert (thrown != null);
            logger.log(Level.WARNING, "Failed to write VOTable metadata to primary HDU", thrown);
            FitsUtil.writeEmptyPrimary(out);
            return;
        }
    }

    private void writeVOTablePrimary(StarTable[] tables, FitsTableSerializer[] fitsers, OutputStream out) throws IOException {
        int ntable = tables.length;
        if (fitsers.length != ntable) {
            throw new IllegalArgumentException("table/serializer count mismatch");
        }
        StringWriter textWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(textWriter);
        VOTableWriter votWriter = new VOTableWriter(null, false, this.votVersion_);
        votWriter.setWriteDate(this.getWriteDate());
        votWriter.writePreTableXML(writer);
        String comment = new StringBuffer().append("<!-- ").append("Describes BINTABLE extensions in the following ").append(ntable == 1 ? "HDU" : ntable + " HDUs").append(".").append("-->").toString();
        writer.write(comment);
        writer.newLine();
        for (int i = 0; i < ntable; ++i) {
            if (i > 0) {
                votWriter.writeBetweenTableXML(writer);
            }
            StarTable table = tables[i];
            FitsTableSerializer fitser = fitsers[i];
            VOSerializer voser = VOSerializer.makeFitsSerializer(tables[i], fitsers[i], this.votVersion_);
            voser.writePreDataXML(writer);
            writer.write("<!-- Dummy VOTable - no DATA element -->");
            writer.newLine();
            voser.writePostDataXML(writer);
        }
        votWriter.writePostTableXML(writer);
        writer.flush();
        byte[] textBytes = textWriter.getBuffer().toString().getBytes(XML_ENCODING);
        int nbyte = textBytes.length;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        CardFactory cf = CardFactory.STRICT;
        cards.addAll(Arrays.asList(cf.createLogicalCard("SIMPLE", true, "Standard FITS format"), cf.createIntegerCard("BITPIX", 8L, "Character data"), cf.createIntegerCard("NAXIS", 1L, "Text string"), cf.createIntegerCard("NAXIS1", nbyte, "Number of characters")));
        cards.addAll(Arrays.asList(this.getCustomPrimaryHeaderCards()));
        cards.add(cf.createLogicalCard("EXTEND", true, "There are standard extensions"));
        String plural = ntable == 1 ? "" : "s";
        String[] comments = new String[]{" ", "The data in this primary HDU consists of bytes which", "comprise a VOTABLE document.", "The VOTable describes the metadata of the table" + plural + " contained", "in the following BINTABLE extension" + plural + ".", "Such a BINTABLE extension can be used on its own as a perfectly", "good table, but the information from this HDU may provide some", "useful additional metadata.", ntable == 1 ? "There is one following BINTABLE." : "There are " + ntable + " following BINTABLEs."};
        for (int i = 0; i < comments.length; ++i) {
            cards.add(cf.createCommentCard(comments[i]));
        }
        cards.add(cf.createIntegerCard("NTABLE", ntable, "Number of following BINTABLE HDUs"));
        cards.add(CardFactory.END_CARD);
        assert (this.primaryHeaderOK(cards.toArray(new CardImage[0])));
        FitsUtil.writeHeader(cards.toArray(new CardImage[0]), out);
        out.write(textBytes);
        int partial = textBytes.length % 2880;
        if (partial > 0) {
            int pad = 2880 - partial;
            out.write(new byte[pad]);
        }
    }

    protected abstract CardImage[] getCustomPrimaryHeaderCards();

    private boolean primaryHeaderOK(CardImage[] cards) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            FitsUtil.writeHeader(cards, bout);
            bout.close();
            return this.isMagic(bout.toByteArray());
        }
        catch (IOException e) {
            assert (false);
            return false;
        }
    }

    public boolean isMagic(byte[] buffer) {
        int ntest = 6;
        if (buffer.length < 480) {
            return false;
        }
        byte[] cbuf = new byte[80];
        for (int il = 0; il < 6; ++il) {
            System.arraycopy(buffer, il * 80, cbuf, 0, 80);
            ParsedCard<?> card = FitsUtil.parseCard(cbuf);
            if (this.isMagic(il, card.getKey(), card.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean isMagic(int icard, String key, Object value) {
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && Boolean.TRUE.equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && value instanceof Number && ((Number)value).intValue() == 8;
            }
            case 2: {
                return "NAXIS".equals(key) && value instanceof Number && ((Number)value).intValue() == 1;
            }
            case 3: {
                return "NAXIS1".equals(key);
            }
        }
        return true;
    }
}

