/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.starlink.auth.AuthConnection;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.BasicAuthScheme;
import uk.ac.starlink.auth.BearerIvoaAuthScheme;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.CookieIvoaAuthScheme;
import uk.ac.starlink.auth.X509IvoaAuthScheme;

public class AuthUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String CHALLENGE_HEADER = "WWW-Authenticate";
    public static final String AUTH_HEADER = "Authorization";
    public static final String AUTHID_HEADER = "X-VO-Authenticated";
    public static final String LOGSECRETS_PROP = "auth.logsecrets";
    public static boolean LOG_SECRETS = "true".equalsIgnoreCase(System.getProperty("auth.logsecrets"));
    public static final String SCHEMES_PROP = "auth.schemes";
    public static final AuthScheme[] DFLT_SCHEMES = new AuthScheme[]{X509IvoaAuthScheme.INSTANCE, CookieIvoaAuthScheme.INSTANCE, BasicAuthScheme.INSTANCE};
    private static final AuthScheme[] OTHER_SCHEMES = new AuthScheme[]{BearerIvoaAuthScheme.INSTANCE};
    public static final AuthScheme[] ALL_SCHEMES = (AuthScheme[])Stream.concat(Stream.of(DFLT_SCHEMES), Stream.of(OTHER_SCHEMES)).toArray(AuthScheme[]::new);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");
    private static AuthScheme[] dfltSchemes_;

    private AuthUtil() {
    }

    public static int getResponseCode(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            try {
                return ((HttpURLConnection)conn).getResponseCode();
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Error retrieving HTTP status code: " + e, e);
                return -1;
            }
        }
        return -1;
    }

    public static Challenge[] getChallenges(URLConnection conn) {
        ArrayList<Challenge> challenges = new ArrayList<Challenge>();
        if (conn != null) {
            for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
                if (!CHALLENGE_HEADER.equalsIgnoreCase(entry.getKey())) continue;
                for (String challengeTxt : entry.getValue()) {
                    challenges.addAll(Challenge.parseChallenges(challengeTxt));
                }
            }
        }
        return challenges.toArray(new Challenge[0]);
    }

    public static String getAuthenticatedId(AuthConnection aconn) {
        int code;
        HttpURLConnection hconn;
        URLConnection conn = aconn.getConnection();
        HttpURLConnection httpURLConnection = hconn = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
        if (conn == null) {
            return null;
        }
        try {
            code = hconn.getResponseCode();
        }
        catch (IOException e) {
            return null;
        }
        AuthContext context = aconn.getContext();
        if (code == 403 || code == 401) {
            return null;
        }
        if (code == 404) {
            return null;
        }
        if (context == null || !context.hasCredentials()) {
            return null;
        }
        String authId = hconn.getHeaderField(AUTHID_HEADER);
        return authId != null && authId.trim().length() > 0 ? authId : "authenticated(unknownID)";
    }

    public static String authFailureMessage(HttpURLConnection hconn) {
        StringBuffer sbuf = new StringBuffer();
        try {
            int code = hconn.getResponseCode();
            sbuf.append(code).append(": ");
            switch (code) {
                case 401: {
                    sbuf.append("Unauthorized - bad credentials");
                    break;
                }
                case 403: {
                    sbuf.append("Forbidden - insufficient privileges");
                    break;
                }
                default: {
                    sbuf.append(hconn.getResponseMessage());
                    break;
                }
            }
        }
        catch (IOException e) {
            sbuf.append("trouble!");
        }
        return sbuf.toString();
    }

    public static String unNullString(String txt) {
        return txt == null ? "" : txt;
    }

    public static String cookieLogText(HttpCookie cookie) {
        return LOG_SECRETS ? cookie.toString() : cookie.getName();
    }

    public static AuthScheme[] getDefaultSchemes() {
        if (dfltSchemes_ == null) {
            dfltSchemes_ = AuthUtil.createDefaultSchemes();
            logger_.log(Arrays.equals(dfltSchemes_, DFLT_SCHEMES) ? Level.CONFIG : Level.WARNING, "Default auth schemes: " + Stream.of(dfltSchemes_).map(s -> s.getName()).collect(Collectors.joining(",")));
        }
        return (AuthScheme[])dfltSchemes_.clone();
    }

    private static AuthScheme[] createDefaultSchemes() {
        String propTxt = System.getProperty(SCHEMES_PROP);
        if (propTxt == null || propTxt.trim().length() == 0) {
            return DFLT_SCHEMES;
        }
        try {
            return AuthUtil.getNamedSchemes(propTxt.split(","));
        }
        catch (Throwable err) {
            logger_.log(Level.WARNING, "Not a list of auth schemes: " + propTxt, err);
            return DFLT_SCHEMES;
        }
    }

    private static AuthScheme[] getNamedSchemes(String[] names) throws ReflectiveOperationException {
        ArrayList<AuthScheme> schemes = new ArrayList<AuthScheme>();
        for (String name : names) {
            AuthScheme scheme = Stream.of(ALL_SCHEMES).filter(s -> name.equalsIgnoreCase(s.getName()) || name.equals(s.getClass().getName())).findFirst().orElse(null);
            if (scheme == null) {
                scheme = (AuthScheme)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            schemes.add(scheme);
        }
        return schemes.toArray(new AuthScheme[0]);
    }

    public static HttpURLConnection postForm(URL url, Map<String, String> params) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection hconn = (HttpURLConnection)conn;
            AuthUtil.postForm(hconn, params);
            return hconn;
        }
        throw new IOException("Not an HTTP URL: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postForm(HttpURLConnection hconn, Map<String, String> params) throws IOException {
        byte[] postBytes = AuthUtil.toPostedBytes(params);
        hconn.setRequestMethod("POST");
        hconn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        hconn.setInstanceFollowRedirects(false);
        hconn.setDoOutput(true);
        hconn.connect();
        try (OutputStream hout = hconn.getOutputStream();){
            hout.write(postBytes);
        }
    }

    private static byte[] toPostedBytes(Map<String, String> paramMap) {
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            if (sbuf.length() != 0) {
                sbuf.append('&');
            }
            try {
                sbuf.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("No UTF-8??");
            }
        }
        int nc = sbuf.length();
        byte[] bbuf = new byte[nc];
        for (int i = 0; i < nc; ++i) {
            char c = sbuf.charAt(i);
            assert (c == (c & 0x7F));
            bbuf[i] = (byte)sbuf.charAt(i);
        }
        return bbuf;
    }
}

