/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType {
    private final String type_;
    private final String subtype_;
    private static final Pattern TYPE_REGEX = Pattern.compile("\\s*([-A-Za-z0-9_]+)\\s*/\\s*([-A-Za-z0-9_]+).*");

    public ContentType(String type, String subtype) {
        this.type_ = type;
        this.subtype_ = subtype;
    }

    public String getType() {
        return this.type_;
    }

    public String getSubtype() {
        return this.subtype_;
    }

    public boolean matches(String type, String subtype) {
        return this.type_.equalsIgnoreCase(type) && this.subtype_.equalsIgnoreCase(subtype);
    }

    public int hashCode() {
        int code = 5501;
        code = 23 * code + this.type_.hashCode();
        code = 23 * code + this.subtype_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof ContentType) {
            ContentType other = (ContentType)o;
            return this.type_.equals(other.type_) && this.subtype_.equals(other.subtype_);
        }
        return false;
    }

    public String toString() {
        return this.type_ + "/" + this.subtype_;
    }

    public static ContentType parse(String txt) {
        if (txt == null) {
            return null;
        }
        Matcher matcher = TYPE_REGEX.matcher(txt);
        return matcher.matches() ? new ContentType(matcher.group(1), matcher.group(2)) : null;
    }
}

