/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcHandler;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.Agent;
import uk.ac.starlink.plastic.BasicApplication;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.NoCallBackAgent;
import uk.ac.starlink.plastic.RequestThread;
import uk.ac.starlink.plastic.RmiAgent;
import uk.ac.starlink.plastic.ServerSet;
import uk.ac.starlink.plastic.XmlRpcAgent;

public class MinimalHub
implements PlasticHubListener,
XmlRpcHandler {
    private final ServerSet servers_;
    private final Map agentMap_;
    private final URI hubId_;
    private int nReg_;
    private boolean stopped_;
    private static final String HUB_ID_KEY = "hub.id";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");

    public MinimalHub(ServerSet servers) throws RemoteException {
        this.servers_ = servers;
        this.agentMap_ = Collections.synchronizedMap(new HashMap());
        this.servers_.getRmiServer().publish(PlasticHubListener.class, this, new Class[]{PlasticListener.class});
        this.servers_.getXmlRpcServer().addHandler("plastic.hub", this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MinimalHub.this.stop();
            }
        });
        BasicApplication servApp = new BasicApplication("hub");
        servApp.setDescription("PlasKit hub");
        this.hubId_ = this.registerRMI(servApp.getName(), Arrays.asList(servApp.getSupportedMessages()), servApp);
    }

    Map getAgentMap() {
        return this.agentMap_;
    }

    @Override
    public URI getHubId() {
        return this.hubId_;
    }

    @Override
    public URI registerRMI(String name, List supportedMessages, PlasticListener caller) {
        RmiAgent agent = new RmiAgent(++this.nReg_, name, this.toUriArray(supportedMessages), caller);
        this.register(agent);
        return agent.getId();
    }

    @Override
    public URI registerXMLRPC(String name, List supportedMessages, URL callbackURL) {
        XmlRpcAgent agent = new XmlRpcAgent(++this.nReg_, name, this.toUriArray(supportedMessages), callbackURL);
        this.register(agent);
        return agent.getId();
    }

    @Override
    public URI registerNoCallBack(String name) {
        NoCallBackAgent agent = new NoCallBackAgent(++this.nReg_, name);
        this.register(agent);
        return agent.getId();
    }

    void register(Agent agent) {
        URI id = agent.getId();
        this.agentMap_.put(id, agent);
        this.requestAsynch(this.hubId_, MessageId.HUB_APPREG, Collections.singletonList(id.toString()));
    }

    @Override
    public void unregister(URI id) {
        while (this.agentMap_.containsKey(id)) {
            Agent agent = (Agent)this.agentMap_.get(id);
            this.requestAsynch(this.hubId_, MessageId.HUB_APPUNREG, Collections.singletonList(id.toString()));
            this.agentMap_.remove(id);
        }
    }

    @Override
    public List getRegisteredIds() {
        return new ArrayList(this.agentMap_.keySet());
    }

    @Override
    public String getName(URI id) {
        Agent agent = (Agent)this.agentMap_.get(id);
        return agent == null ? null : agent.getName();
    }

    @Override
    public List getUnderstoodMessages(URI id) {
        Agent agent = (Agent)this.agentMap_.get(id);
        return agent == null ? null : new ArrayList<URI>(Arrays.asList(agent.getSupportedMessages()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMessageRegisteredIds(URI message) {
        ArrayList<URI> supporters = new ArrayList<URI>();
        Map map = this.agentMap_;
        synchronized (map) {
            for (Map.Entry entry : this.agentMap_.entrySet()) {
                URI id = (URI)entry.getKey();
                Agent agent = (Agent)entry.getValue();
                URI[] messages = agent.getSupportedMessages();
                boolean add = messages == null || messages.length == 0 ? this.isPre05() : Arrays.asList(messages).contains(message);
                if (!add) continue;
                supporters.add(id);
            }
        }
        return supporters;
    }

    @Override
    public Object execute(String method, Vector params) throws IOException, URISyntaxException {
        String name;
        URI id;
        Object result;
        ArrayList paramList = new ArrayList(params);
        if ("plastic.hub.getRegisteredIds".equals(method)) {
            result = this.getRegisteredIds();
        } else if ("plastic.hub.getHubId".equals(method)) {
            result = this.getHubId().toString();
        } else if ("plastic.hub.getName".equals(method)) {
            id = new URI((String)paramList.remove(0));
            result = this.getName(id);
        } else if ("plastic.hub.getUnderstoodMessages".equals(method)) {
            id = new URI((String)paramList.remove(0));
            result = this.getUnderstoodMessages(id);
        } else if ("plastic.hub.getMessageRegisteredIds".equals(method)) {
            URI message = new URI((String)paramList.remove(0));
            result = this.getMessageRegisteredIds(message);
        } else if ("plastic.hub.registerXMLRPC".equals(method)) {
            name = (String)paramList.remove(0);
            List supportedMessages = (List)paramList.remove(0);
            URL callBackUrl = new URL((String)paramList.remove(0));
            result = this.registerXMLRPC(name, this.toUriList(supportedMessages), callBackUrl);
        } else {
            URI sender;
            if ("plastic.hub.registerRMI".equals(method)) {
                throw new IOException("Can't registerRMI using XML-RPC");
            }
            if ("plastic.hub.registerNoCallBack".equals(method)) {
                name = (String)paramList.remove(0);
                result = this.registerNoCallBack(name);
            } else if ("plastic.hub.unregister".equals(method)) {
                id = new URI((String)paramList.remove(0));
                this.unregister(id);
                result = null;
            } else if ("plastic.hub.request".equals(method)) {
                sender = new URI((String)paramList.remove(0));
                URI message = new URI((String)paramList.remove(0));
                List args = (List)paramList.remove(0);
                result = this.request(sender, message, args);
            } else if ("plastic.hub.requestAsynch".equals(method)) {
                sender = new URI((String)paramList.remove(0));
                URI message = new URI((String)paramList.remove(0));
                List args = (List)paramList.remove(0);
                this.requestAsynch(sender, message, args);
                result = null;
            } else if ("plastic.hub.requestToSubset".equals(method)) {
                sender = new URI((String)paramList.remove(0));
                URI message = new URI((String)paramList.remove(0));
                List args = (List)paramList.remove(0);
                List recipientIds = (List)paramList.remove(0);
                result = this.requestToSubset(sender, message, args, this.toUriList(recipientIds));
            } else if ("plastic.hub.requestToSubsetAsynch".equals(method)) {
                sender = new URI((String)paramList.remove(0));
                URI message = new URI((String)paramList.remove(0));
                List args = (List)paramList.remove(0);
                List recipientIds = (List)paramList.remove(0);
                this.requestToSubsetAsynch(sender, message, args, this.toUriList(recipientIds));
                result = null;
            } else {
                throw new UnsupportedOperationException("No method " + method + " on hub");
            }
        }
        Object xResult = XmlRpcAgent.doctorObject(result);
        return xResult;
    }

    @Override
    public Map request(URI sender, URI message, List args) {
        return this.requestTo(sender, message, args, this.getOtherAgents(sender));
    }

    @Override
    public Map requestToSubset(URI sender, URI message, List args, List recipientIds) {
        return this.requestTo(sender, message, args, this.getSelectedAgents(recipientIds));
    }

    @Override
    public void requestAsynch(URI sender, URI message, List args) {
        this.requestAsynchTo(sender, message, args, this.getOtherAgents(sender));
    }

    @Override
    public void requestToSubsetAsynch(URI sender, URI message, List args, List recipientIds) {
        this.requestAsynchTo(sender, message, args, this.getSelectedAgents(recipientIds));
    }

    public URI registerPolling(String name, List supportedMessages) {
        throw new UnsupportedOperationException("Polling not supported");
    }

    public List pollForMessages(URI id) {
        throw new UnsupportedOperationException("Polling not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent[] getOtherAgents(URI excluded) {
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        Map map = this.agentMap_;
        synchronized (map) {
            for (URI id : this.agentMap_.keySet()) {
                Agent agent;
                if (id == null || id.equals(excluded) || (agent = (Agent)this.agentMap_.get(id)) == null) continue;
                agentList.add(agent);
            }
        }
        return agentList.toArray(new Agent[0]);
    }

    private Agent[] getSelectedAgents(List idList) {
        ArrayList<Agent> agentList = new ArrayList<Agent>();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            Agent agent = (Agent)this.agentMap_.get(it.next());
            if (agent == null) continue;
            agentList.add(agent);
        }
        return agentList.toArray(new Agent[0]);
    }

    Map requestTo(URI sender, URI message, List args, Agent[] agents) {
        RequestThread[] threads = this.startRequestThreads(sender, message, args, agents);
        HashMap<URI, Object> results = new HashMap<URI, Object>();
        for (int i = 0; i < threads.length; ++i) {
            Object result;
            RequestThread thread = threads[i];
            try {
                thread.join();
                result = thread.getResult();
            }
            catch (IOException e) {
                result = null;
            }
            catch (InterruptedException e) {
                result = null;
            }
            results.put(thread.getAgent().getId(), result);
        }
        return results;
    }

    void requestAsynchTo(URI sender, URI message, List args, Agent[] agents) {
        this.startRequestThreads(sender, message, args, agents);
    }

    private RequestThread[] startRequestThreads(URI sender, URI message, List args, Agent[] agents) {
        ArrayList<RequestThread> threadList = new ArrayList<RequestThread>();
        for (int i = 0; i < agents.length; ++i) {
            Agent agent = agents[i];
            if (!agent.supportsMessage(message)) continue;
            threadList.add(this.createRequestThread(agent, sender, message, args));
        }
        RequestThread[] threads = threadList.toArray(new RequestThread[0]);
        for (int i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        return threads;
    }

    RequestThread createRequestThread(Agent agent, URI sender, URI message, List args) {
        return new RequestThread(agent, sender, message, args);
    }

    boolean isPre05() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean stop;
        MinimalHub minimalHub = this;
        synchronized (minimalHub) {
            stop = !this.stopped_;
            this.stopped_ = true;
        }
        if (stop) {
            try {
                this.requestAsynch(this.getHubId(), MessageId.HUB_STOPPING, new ArrayList());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.servers_.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized boolean isStopped() {
        return this.stopped_;
    }

    public void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    private URI[] toUriArray(List list) {
        return list.toArray(new URI[0]);
    }

    private List toUriList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList uriList = new ArrayList();
        for (Object obj : list) {
            if (obj instanceof URI) {
                uriList.add(obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    uriList.add(new URI((String)obj));
                }
                catch (URISyntaxException e) {
                    logger_.warning("Bad URI string: " + obj);
                }
                continue;
            }
            logger_.warning("Can't make URI from " + obj);
        }
        return uriList;
    }

    static URI createId(Object obj, String text, int iseq) {
        text = text.replaceAll("[^A-Za-z0-9_]+", "_");
        try {
            return new URI("plastic://" + obj.getClass().getName() + "/" + Integer.toHexString(System.identityHashCode(obj)) + "-" + iseq + "-" + text);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(String[] args) throws IOException, RemoteException {
        if (args.length > 0) {
            System.err.println("Usage: " + MinimalHub.class.getName());
            System.err.println("See uk.ac.starlink.plastic.PlasticHub for fancy options");
            System.exit(1);
        }
        ServerSet servers = new ServerSet(new File(System.getProperty("user.home"), ".plastic"));
        final MinimalHub hub = new MinimalHub(servers);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                hub.stop();
            }
        });
    }
}

