/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.plastic.XmlRpcAgent;

class XmlRpcHub
implements PlasticHubListener {
    private final XmlRpcClient client_;
    private final PlasticHubListener properHub_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");

    public XmlRpcHub(URL xmlrpcUrl, PlasticHubListener properHub) {
        this.client_ = PlasticUtils.createXmlRpcClient(xmlrpcUrl);
        this.properHub_ = properHub;
    }

    @Override
    public List getRegisteredIds() {
        return XmlRpcHub.toUriList((List)this.xmlrpcCall("getRegisteredIds", new Object[0]));
    }

    @Override
    public URI getHubId() {
        return XmlRpcHub.toUri(this.xmlrpcCall("getHubId", new Object[0]));
    }

    @Override
    public String getName(URI id) {
        return (String)this.xmlrpcCall("getName", new Object[]{id});
    }

    @Override
    public List getUnderstoodMessages(URI id) {
        return XmlRpcHub.toUriList((List)this.xmlrpcCall("getUnderstoodMessages", new Object[]{id}));
    }

    @Override
    public List getMessageRegisteredIds(URI message) {
        return XmlRpcHub.toUriList((List)this.xmlrpcCall("getMessageRegisteredIds", new Object[]{message}));
    }

    @Override
    public URI registerXMLRPC(String name, List supportedMessages, URL callbackURL) {
        return XmlRpcHub.toUri(this.xmlrpcCall("registerXMLRPC", new Object[]{name, supportedMessages, callbackURL}));
    }

    @Override
    public URI registerRMI(String name, List supportedMessages, PlasticListener caller) {
        return this.properHub_.registerRMI(name, supportedMessages, caller);
    }

    @Override
    public URI registerNoCallBack(String name) {
        return XmlRpcHub.toUri(this.xmlrpcCall("registerNoCallBack", new Object[]{name}));
    }

    public URI registerRMI(String name, List supportedMessages, URL callbackUrl) {
        return XmlRpcHub.toUri(this.xmlrpcCall("registerRMI", new Object[]{name, supportedMessages, callbackUrl}));
    }

    @Override
    public void unregister(URI id) {
        this.xmlrpcCall("unregister", new Object[]{id});
    }

    @Override
    public Map request(URI sender, URI message, List args) {
        return XmlRpcHub.toUriMap((Map)this.xmlrpcCall("request", new Object[]{sender, message, args}));
    }

    @Override
    public Map requestToSubset(URI sender, URI message, List args, List recipientIds) {
        return XmlRpcHub.toUriMap((Map)this.xmlrpcCall("requestToSubset", new Object[]{sender, message, args, recipientIds}));
    }

    @Override
    public void requestToSubsetAsynch(URI sender, URI message, List args, List recipientIds) {
        this.xmlrpcCall("requestToSubsetAsynch", new Object[]{sender, message, args, recipientIds});
    }

    @Override
    public void requestAsynch(URI sender, URI message, List args) {
        this.xmlrpcCall("requestAsynch", new Object[]{sender, message, args});
    }

    private Object xmlrpcCall(String method, Object[] args) {
        Vector<Object> argv = new Vector<Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                argv.add(XmlRpcAgent.doctorObject(args[i]));
            }
        }
        try {
            Object result = this.client_.execute("plastic.hub." + method, argv);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
            return result;
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "XML-RPC Execution error: " + e, e);
            return null;
        }
    }

    private static URI toUri(Object obj) {
        try {
            return new URI((String)obj);
        }
        catch (Exception e) {
            logger_.warning("Bad URI " + obj + " - returning null");
            return null;
        }
    }

    private static List toUriList(List list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, XmlRpcHub.toUri(list.get(i)));
        }
        return list;
    }

    private static Map toUriMap(Map map) {
        if (map == null) {
            return null;
        }
        Hashtable fixMap = new Hashtable();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            fixMap.put(XmlRpcHub.toUri(entry.getKey()), entry.getValue());
        }
        return fixMap;
    }
}

