/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.tfcat.Reporter;
import uk.ac.starlink.tfcat.WordChecker;

public class BasicReporter
implements Reporter {
    private final boolean isDebug_;
    private final String context_;
    private final List<String> messages_;
    private final WordChecker ucdChecker_;
    private final WordChecker unitChecker_;

    public BasicReporter(boolean isDebug) {
        this(isDebug, null, null);
    }

    public BasicReporter(boolean isDebug, WordChecker ucdChecker, WordChecker unitChecker) {
        this(isDebug, ucdChecker, unitChecker, null, new ArrayList<String>());
    }

    private BasicReporter(BasicReporter template, String context) {
        this(template.isDebug_, template.ucdChecker_, template.unitChecker_, context, template.messages_);
    }

    private BasicReporter(boolean isDebug, WordChecker ucdChecker, WordChecker unitChecker, String context, List<String> messages) {
        this.isDebug_ = isDebug;
        this.ucdChecker_ = ucdChecker;
        this.unitChecker_ = unitChecker;
        this.context_ = context;
        this.messages_ = messages;
    }

    public List<String> getMessages() {
        return this.messages_;
    }

    @Override
    public BasicReporter createReporter(String subContext) {
        String context = this.context_ == null ? subContext : this.context_ + "/" + subContext;
        return new BasicReporter(this, context);
    }

    @Override
    public BasicReporter createReporter(int subContext) {
        String context = (this.context_ == null ? "" : this.context_) + "[" + subContext + "]";
        return new BasicReporter(this, context);
    }

    @Override
    public void report(String message) {
        StringBuffer sbuf = new StringBuffer();
        if (this.context_ != null) {
            sbuf.append(this.context_).append(": ");
        }
        sbuf.append(message);
        String txt = sbuf.toString();
        this.messages_.add(txt);
        if (this.isDebug_) {
            System.err.println(txt);
            Thread.dumpStack();
            System.err.println();
        }
    }

    @Override
    public void checkUcd(String ucd) {
        String report;
        if (this.ucdChecker_ != null && ucd != null && (report = this.ucdChecker_.checkWord(ucd)) != null) {
            this.report(report);
        }
    }

    @Override
    public void checkUnit(String unit) {
        String report;
        if (this.unitChecker_ != null && unit != null && (report = this.unitChecker_.checkWord(unit)) != null) {
            this.report(report);
        }
    }
}

