/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

public abstract class Datatype<T> {
    private final String name_;
    private final Class<T> clazz_;
    public static final Datatype<Long> INT;
    public static final Datatype<Double> FLOAT;
    public static final Datatype<Boolean> BOOL;
    public static final Datatype<String> STRING;
    private static final Datatype<?>[] ALL_TYPES;

    private Datatype(String name, Class<T> clazz) {
        this.name_ = name;
        this.clazz_ = clazz;
    }

    public String getName() {
        return this.name_;
    }

    public Class<T> getTypeClass() {
        return this.clazz_;
    }

    public abstract T decode(String var1);

    public abstract boolean isType(String var1);

    public String toString() {
        return this.name_;
    }

    public static Datatype<?> forName(String name) {
        for (Datatype<?> t : ALL_TYPES) {
            if (!t.name_.equals(name)) continue;
            return t;
        }
        return null;
    }

    static {
        Datatype[] datatypeArray = new Datatype[4];
        INT = new Datatype<Long>("int", Long.class){

            @Override
            public boolean isType(String txt) {
                return txt.matches("[+-]?[0-9]+");
            }

            @Override
            public Long decode(String txt) {
                return Long.valueOf(txt);
            }
        };
        datatypeArray[0] = INT;
        FLOAT = new Datatype<Double>("float", Double.class){

            @Override
            public boolean isType(String txt) {
                return txt.matches("-?[0-9]+([.][0-9]+)?([eE][+-]?[0-9]+)?");
            }

            @Override
            public Double decode(String txt) {
                return Double.parseDouble(txt);
            }
        };
        datatypeArray[1] = FLOAT;
        BOOL = new Datatype<Boolean>("bool", Boolean.class){

            @Override
            public boolean isType(String txt) {
                return "true".equals(txt) || "false".equals(txt);
            }

            @Override
            public Boolean decode(String txt) {
                if ("true".equals(txt)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(txt)) {
                    return Boolean.FALSE;
                }
                return null;
            }
        };
        datatypeArray[2] = BOOL;
        STRING = new Datatype<String>("str", String.class){

            @Override
            public boolean isType(String txt) {
                return true;
            }

            @Override
            public String decode(String txt) {
                return txt;
            }
        };
        datatypeArray[3] = STRING;
        ALL_TYPES = datatypeArray;
    }
}

