/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.tfcat.Reporter;

class JsonTool {
    private final Reporter reporter_;

    public JsonTool(Reporter reporter) {
        this.reporter_ = reporter;
    }

    public String asString(Object json, boolean isRequired) {
        if (json instanceof String) {
            return (String)json;
        }
        if (JsonTool.isNull(json)) {
            if (isRequired) {
                this.reporter_.report("missing value");
            }
            return null;
        }
        this.reporter_.report("non-string value");
        return null;
    }

    public String asStringOrNumber(Object json, boolean isRequired) {
        if (json instanceof String || json instanceof Number) {
            return json.toString();
        }
        if (JsonTool.isNull(json)) {
            if (isRequired) {
                this.reporter_.report("missing value");
            }
            return null;
        }
        this.reporter_.report("non-string/numeric value");
        return null;
    }

    public double[] asNumericArray(Object json, int nreq) {
        boolean isNanPermitted = false;
        if (json instanceof JSONArray) {
            JSONArray jarray = (JSONArray)json;
            int nd = jarray.length();
            if (nreq > 0 && nreq != nd) {
                this.reporter_.report("wrong array length (" + nd + " != " + nreq + ")");
                return null;
            }
            double[] darray = new double[nd];
            for (int id = 0; id < nd; ++id) {
                double dval;
                Object item = jarray.get(id);
                if (JsonTool.isNull(item) && isNanPermitted) {
                    dval = Double.NaN;
                } else if (item instanceof Number) {
                    dval = ((Number)item).doubleValue();
                } else {
                    this.reporter_.createReporter(id).report("non-numeric value (" + item + ")");
                    return null;
                }
                darray[id] = dval;
            }
            return darray;
        }
        if (JsonTool.isNull(json)) {
            this.reporter_.report("missing array");
            return null;
        }
        this.reporter_.report("non-array value");
        return null;
    }

    public JSONObject asJSONObject(Object json) {
        if (json instanceof JSONObject) {
            return (JSONObject)json;
        }
        if (JsonTool.isNull(json)) {
            this.reporter_.report("missing object");
            return null;
        }
        this.reporter_.report("non-object value");
        return null;
    }

    public JSONArray asJSONArray(Object json) {
        if (json instanceof JSONArray) {
            return (JSONArray)json;
        }
        if (JsonTool.isNull(json)) {
            this.reporter_.report("missing array");
            return null;
        }
        this.reporter_.report("non-array value");
        return null;
    }

    public void requireAbsent(JSONObject json, String member) {
        if (json.has(member)) {
            this.reporter_.report("has illegal member \"" + member + "\"");
        }
    }

    public static boolean isNull(Object json) {
        return json == null || JSONObject.NULL.equals(json);
    }
}

