/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import ari.ucidy.UCD;
import ari.ucidy.UCDParser;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.starlink.tfcat.Bbox;
import uk.ac.starlink.tfcat.Crs;
import uk.ac.starlink.tfcat.Decoders;
import uk.ac.starlink.tfcat.DummyReporter;
import uk.ac.starlink.tfcat.Feature;
import uk.ac.starlink.tfcat.FeatureCollection;
import uk.ac.starlink.tfcat.Geometry;
import uk.ac.starlink.tfcat.LinearRing;
import uk.ac.starlink.tfcat.Position;
import uk.ac.starlink.tfcat.Reporter;
import uk.ac.starlink.tfcat.TfcatObject;
import uk.ac.starlink.tfcat.WordChecker;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParser;

public class TfcatUtil {
    private static final TfcatObject[] NO_TFCATS = new TfcatObject[0];
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.tfcat");
    private static final Logger ucidyLogger_ = Logger.getLogger("ari.ucidy");
    private static WordChecker ucdChecker_;
    private static WordChecker unitChecker_;

    private TfcatUtil() {
    }

    public static TfcatObject parseTfcat(String jsonTxt, Reporter reporter) {
        JSONObject json;
        if (jsonTxt == null) {
            return null;
        }
        if (reporter == null) {
            reporter = DummyReporter.INSTANCE;
        }
        if (TfcatUtil.getFirstChar(jsonTxt) != '{' || TfcatUtil.getLastChar(jsonTxt) != '}') {
            reporter.report("Not JSON object");
        }
        try {
            json = new JSONObject(jsonTxt);
        }
        catch (JSONException e) {
            reporter.report("Bad JSON: " + e.getMessage());
            return null;
        }
        TfcatObject tfcat = Decoders.TFCAT.decode(reporter, json, null);
        if (tfcat != null && reporter != DummyReporter.INSTANCE) {
            TfcatUtil.checkBoundingBoxes(reporter, tfcat);
            TfcatUtil.checkCrs(reporter, tfcat);
        }
        return tfcat;
    }

    public static TfcatObject[] getChildren(TfcatObject tfcat) {
        if (tfcat instanceof FeatureCollection) {
            return ((FeatureCollection)tfcat).getFeatures();
        }
        if (tfcat instanceof Feature) {
            return new TfcatObject[]{((Feature)tfcat).getGeometry()};
        }
        if (tfcat instanceof Geometry) {
            Object shape = ((Geometry)tfcat).getShape();
            return shape instanceof Geometry[] ? (Geometry[])shape : NO_TFCATS;
        }
        assert (false);
        return NO_TFCATS;
    }

    public static List<Geometry<?>> getAllGeometries(TfcatObject tfcat) {
        if (tfcat instanceof Geometry) {
            Geometry geom = (Geometry)tfcat;
            Object shape = geom.getShape();
            if (shape instanceof Geometry[]) {
                ArrayList list = new ArrayList();
                for (Geometry g : (Geometry[])shape) {
                    list.addAll(TfcatUtil.getAllGeometries(g));
                }
                return list;
            }
            return Collections.singletonList(geom);
        }
        if (tfcat instanceof FeatureCollection) {
            ArrayList list = new ArrayList();
            for (Feature feat : ((FeatureCollection)tfcat).getFeatures()) {
                list.addAll(TfcatUtil.getAllGeometries(feat.getGeometry()));
            }
            return list;
        }
        if (tfcat instanceof Feature) {
            return TfcatUtil.getAllGeometries(((Feature)tfcat).getGeometry());
        }
        assert (false);
        return Collections.emptyList();
    }

    public static List<Position> getAllPositions(TfcatObject tfcat) {
        ArrayList<Position> list = new ArrayList<Position>();
        for (Geometry<?> geom : TfcatUtil.getAllGeometries(tfcat)) {
            list.addAll(TfcatUtil.getPositionsFromShape(geom.getShape()));
        }
        return list;
    }

    public static void checkBoundingBoxes(Reporter reporter, TfcatObject tfcat) {
        Reporter tReporter = reporter.createReporter(tfcat.getType());
        for (TfcatObject subObj : TfcatUtil.getChildren(tfcat)) {
            TfcatUtil.checkBoundingBoxes(tReporter, subObj);
        }
        Bbox bbox = tfcat.getBbox();
        if (bbox != null) {
            for (Position pos : TfcatUtil.getAllPositions(tfcat)) {
                if (bbox.isInside(pos)) continue;
                tReporter.report("bounding box violation (" + pos + " outside " + bbox + ")");
                return;
            }
        }
    }

    public static Crs getCrsInScope(TfcatObject tfcat) {
        return TfcatUtil.getMemberInScope(tfcat, TfcatObject::getCrs);
    }

    public static Bbox getBboxInScope(TfcatObject tfcat) {
        return TfcatUtil.getMemberInScope(tfcat, TfcatObject::getBbox);
    }

    private static <T> T getMemberInScope(TfcatObject tfcat, Function<TfcatObject, T> get) {
        T member0 = get.apply(tfcat);
        if (member0 != null) {
            return member0;
        }
        TfcatObject parent = tfcat.getParent();
        return parent == null ? null : (T)TfcatUtil.getMemberInScope(parent, get);
    }

    public static void checkCrs(Reporter reporter, TfcatObject tfcat) {
        if (TfcatUtil.getCrsInScope(tfcat) != null) {
            return;
        }
        if (!TfcatUtil.allGeometriesHaveCrs(tfcat)) {
            reporter.report("No top-level CRS, and at least one Geometry lacks CRS");
        }
    }

    public static void checkOption(Reporter reporter, String token, Collection<String> options) {
        if (!options.contains(token)) {
            reporter.report("Disallowed value \"" + token + "\" (not in " + options + ")");
        }
    }

    public static WordChecker getUcdChecker() {
        if (ucdChecker_ == null) {
            ucdChecker_ = TfcatUtil.createUcdChecker();
        }
        return ucdChecker_;
    }

    public static WordChecker getUnitChecker() {
        if (unitChecker_ == null) {
            unitChecker_ = TfcatUtil.createUnitChecker();
        }
        return unitChecker_;
    }

    private static WordChecker createUcdChecker() {
        try {
            UCDParser.class.toString();
        }
        catch (NoClassDefFoundError e) {
            logger_.warning("Ucidy library unavailable: no UCD checking");
            return ucd -> null;
        }
        ucidyLogger_.setLevel(Level.OFF);
        return ucd -> {
            UCD pucd = UCDParser.defaultParser.parse(ucd);
            Iterator<String> errit = pucd.getErrors();
            return errit.hasNext() ? errit.next() : null;
        };
    }

    private static WordChecker createUnitChecker() {
        try {
            UnitParser.class.toString();
        }
        catch (NoClassDefFoundError e) {
            logger_.warning("Unity library unavailable: no unit checking");
            return unit -> null;
        }
        return unit -> {
            UnitExpr punit;
            Syntax syntax = Syntax.VOUNITS;
            try {
                punit = new UnitParser(syntax, unit).getParsed();
            }
            catch (Exception e) {
                return "bad unit \"" + unit + "\" (" + e.getMessage() + ")";
            }
            if (punit.isFullyConformant(syntax)) {
                return null;
            }
            for (OneUnit word : punit) {
                if (!word.isRecognisedUnit(syntax)) {
                    return "unrecognised unit \"" + word + "\"";
                }
                if (word.isRecommendedUnit(syntax)) continue;
                return "deprecated unit \"" + word + "\"";
            }
            return "unidentified problem with unit \"" + unit + "\"";
        };
    }

    private static List<Position> getPositionsFromShape(Object shape) {
        if (shape == null) {
            return Collections.emptyList();
        }
        if (shape instanceof Position) {
            return Collections.singletonList((Position)shape);
        }
        if (shape instanceof LinearRing) {
            return TfcatUtil.getPositionsFromShape(((LinearRing)shape).getDistinctPositions());
        }
        if (shape.getClass().isArray()) {
            ArrayList<Position> list = new ArrayList<Position>();
            for (int i = 0; i < Array.getLength(shape); ++i) {
                list.addAll(TfcatUtil.getPositionsFromShape(Array.get(shape, i)));
            }
            return list;
        }
        assert (false);
        return Collections.emptyList();
    }

    private static boolean allGeometriesHaveCrs(TfcatObject tfcat) {
        if (tfcat instanceof Geometry && !(tfcat instanceof Geometry.GeometryCollection) && TfcatUtil.getCrsInScope(tfcat) == null) {
            return false;
        }
        for (TfcatObject subObj : TfcatUtil.getChildren(tfcat)) {
            if (TfcatUtil.allGeometriesHaveCrs(subObj)) continue;
            return false;
        }
        return true;
    }

    private static char getFirstChar(String txt) {
        int leng = txt.length();
        block3: for (int ic = 0; ic < leng; ++ic) {
            char c = txt.charAt(ic);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return c;
                }
            }
        }
        return ' ';
    }

    private static char getLastChar(String txt) {
        block3: for (int ic = txt.length() - 1; ic >= 0; --ic) {
            char c = txt.charAt(ic);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return c;
                }
            }
        }
        return ' ';
    }
}

