/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import uk.ac.starlink.tfcat.BasicReporter;
import uk.ac.starlink.tfcat.Decoders;
import uk.ac.starlink.tfcat.TfcatObject;
import uk.ac.starlink.tfcat.TfcatUtil;

public class Validate {
    public static void main(String[] args) throws IOException {
        String inFile;
        String usage = "\n   " + Validate.class.getSimpleName() + ": [-help] [-debug] <file>|-\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean isDebug = false;
        Iterator argIt = argList.iterator();
        while (argIt.hasNext()) {
            String arg = (String)argIt.next();
            if (arg.startsWith("-h")) {
                argIt.remove();
                System.out.println(usage);
                return;
            }
            if (!"-debug".equals(arg)) continue;
            argIt.remove();
            isDebug = true;
        }
        if (argList.size() != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        try (InputStream in = "-".equals(inFile = (String)argList.get(0)) ? System.in : new FileInputStream(inFile);){
            BasicReporter reporter = new BasicReporter(isDebug, TfcatUtil.getUcdChecker(), TfcatUtil.getUnitChecker());
            try {
                JSONObject json = new JSONObject(new JSONTokener(in));
                TfcatObject tfcat = Decoders.TFCAT.decode(reporter, json, null);
                if (tfcat != null) {
                    tfcat.purgeJson();
                    TfcatUtil.checkBoundingBoxes(reporter, tfcat);
                    TfcatUtil.checkCrs(reporter, tfcat);
                } else {
                    reporter.report("No TFCat object found at top level");
                }
            }
            catch (JSONException e) {
                reporter.report("Bad JSON: " + e.getMessage());
            }
            List<String> msgs = reporter.getMessages();
            if (msgs.size() == 0) {
                return;
            }
            System.out.println("FAIL (" + msgs.size() + ")");
            for (String msg : msgs) {
                System.out.println("    " + msg);
            }
            System.exit(1);
        }
    }
}

