/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.LongList;

class Binners {
    private Binners() {
    }

    public static <K, E> ObjectBinner<K, E> createObjectBinner() {
        return new CombinationObjectBinner();
    }

    public static <K, E> ObjectBinner<K, E> createModifiableObjectBinner() {
        return new StorageListObjectBinner();
    }

    public static LongBinner createLongBinner(long nrow) {
        return Binners.createLongBinner(nrow >= 0L && nrow < Integer.MAX_VALUE);
    }

    public static LongBinner createLongBinner(boolean isIntSize) {
        return isIntSize ? new CombinationIntLongBinner() : new LongListLongBinner();
    }

    private static class StorageList<E>
    extends LinkedList<E> {
        private StorageList() {
        }
    }

    private static class CombinationIntLongBinner
    extends MapLongBinner<Object> {
        private static int MAX_ARRAY_SIZE = 32;
        private Integer lastInt_ = -1;
        private int[] lastInts_ = new int[0];

        private CombinationIntLongBinner() {
        }

        @Override
        protected Object addToListable(Object listable, long ltem) {
            int item = Tables.checkedLongToInt(ltem);
            if (listable == null) {
                if (this.lastInt_ != item) {
                    this.lastInt_ = item;
                }
                return this.lastInt_;
            }
            if (listable instanceof Integer) {
                int[] nArray;
                int i1 = (Integer)listable;
                int i2 = item;
                if (this.lastInts_.length == 2 && this.lastInts_[0] == i1 && this.lastInts_[1] == i2) {
                    nArray = this.lastInts_;
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = i1;
                    nArray = nArray2;
                    nArray2[1] = i2;
                }
                return nArray;
            }
            if (listable instanceof int[]) {
                int[] oldItems = (int[])listable;
                int nItem = oldItems.length;
                if (nItem < MAX_ARRAY_SIZE) {
                    int[] newItems = new int[nItem + 1];
                    System.arraycopy(oldItems, 0, newItems, 0, nItem);
                    newItems[nItem] = item;
                    return Arrays.equals(newItems, this.lastInts_) ? this.lastInts_ : newItems;
                }
                assert (nItem == MAX_ARRAY_SIZE);
                IntList list = new IntList(oldItems){

                    @Override
                    protected int nextCapacity(int currentCapacity) {
                        return currentCapacity * 5 / 4 + 1;
                    }
                };
                list.add(item);
                return list;
            }
            if (listable instanceof IntList) {
                IntList list = (IntList)listable;
                list.add(item);
                return list;
            }
            assert (false);
            return null;
        }

        @Override
        protected long[] getLongsFromListable(Object listable) {
            if (listable == null) {
                return null;
            }
            if (listable instanceof Integer) {
                return new long[]{((Integer)listable).intValue()};
            }
            if (listable instanceof int[]) {
                int[] items = (int[])listable;
                long[] ltems = new long[items.length];
                for (int i = 0; i < items.length; ++i) {
                    ltems[i] = items[i];
                }
                return ltems;
            }
            if (listable instanceof IntList) {
                IntList list = (IntList)listable;
                int nItem = list.size();
                long[] ltems = new long[nItem];
                for (int i = 0; i < nItem; ++i) {
                    ltems[i] = list.get(i);
                }
                return ltems;
            }
            assert (false);
            return null;
        }

        @Override
        protected Object combineListables(Object listable1, Object listable2) {
            Object addenda;
            Object result;
            if (this.getListableLength(listable1) > this.getListableLength(listable2)) {
                result = listable1;
                addenda = listable2;
            } else {
                result = listable2;
                addenda = listable1;
            }
            for (long ltem : this.getLongsFromListable(addenda)) {
                result = this.addToListable(result, ltem);
            }
            return result;
        }

        private int getListableLength(Object listable) {
            if (listable == null) {
                return 0;
            }
            if (listable instanceof Integer) {
                return 1;
            }
            if (listable instanceof int[]) {
                return ((int[])listable).length;
            }
            if (listable instanceof IntList) {
                return ((IntList)listable).size();
            }
            assert (false);
            return -1;
        }
    }

    private static class LongListLongBinner
    extends MapLongBinner<LongList> {
        private LongListLongBinner() {
        }

        @Override
        protected LongList addToListable(LongList list, long item) {
            if (list == null) {
                list = new LongList(1);
            }
            list.add(item);
            return list;
        }

        @Override
        protected long[] getLongsFromListable(LongList list) {
            return list == null ? null : list.toLongArray();
        }

        @Override
        protected LongList combineListables(LongList list1, LongList list2) {
            if (list1.size() > list2.size()) {
                list1.addAll(list2);
                return list1;
            }
            list2.addAll(list1);
            return list2;
        }
    }

    private static abstract class MapLongBinner<L>
    implements LongBinner {
        final Map<Object, L> map_ = new HashMap<Object, L>();

        private MapLongBinner() {
        }

        @Override
        public void addItem(Object key, long item) {
            this.map_.put(key, this.addToListable(this.map_.get(key), item));
        }

        @Override
        public long[] getLongs(Object key) {
            return this.getLongsFromListable(this.map_.get(key));
        }

        @Override
        public Iterator<?> getKeyIterator() {
            return this.map_.keySet().iterator();
        }

        @Override
        public long getBinCount() {
            return this.map_.size();
        }

        @Override
        public LongBinner combine(LongBinner o) {
            MapLongBinner other = (MapLongBinner)o;
            if (this.getBinCount() > other.getBinCount()) {
                this.addBinner(other);
                return this;
            }
            other.addBinner(this);
            return other;
        }

        private void addBinner(MapLongBinner<L> other) {
            for (Map.Entry<Object, L> entry : other.map_.entrySet()) {
                Object key = entry.getKey();
                L otherListable = entry.getValue();
                L thisListable = this.map_.get(key);
                L combinedListable = thisListable == null ? otherListable : this.combineListables(thisListable, otherListable);
                this.map_.put(key, combinedListable);
            }
        }

        protected abstract L addToListable(L var1, long var2);

        protected abstract long[] getLongsFromListable(L var1);

        protected abstract L combineListables(L var1, L var2);
    }

    private static class CombinationObjectBinner<K, E>
    extends MapObjectBinner<K, E, Object> {
        private CombinationObjectBinner() {
        }

        @Override
        protected Object addToListable(Object listable, E item) {
            if (item instanceof StorageList) {
                throw new IllegalArgumentException("Can't mix keys with values");
            }
            if (listable == null) {
                return item;
            }
            if (listable instanceof StorageList) {
                StorageList list = (StorageList)listable;
                list.add(item);
                return listable;
            }
            StorageList<Object> list = new StorageList<Object>();
            Object singleElement = listable;
            list.add(singleElement);
            list.add(item);
            return list;
        }

        @Override
        protected List<E> getListFromListable(Object listable) {
            if (listable == null) {
                return null;
            }
            if (listable instanceof StorageList) {
                StorageList list = (StorageList)listable;
                return list;
            }
            Object singleElement = listable;
            return Collections.singletonList(singleElement);
        }
    }

    private static class StorageListObjectBinner<K, E>
    extends MapObjectBinner<K, E, StorageList<E>> {
        private StorageListObjectBinner() {
        }

        @Override
        protected StorageList<E> addToListable(StorageList<E> list, E item) {
            if (list == null) {
                list = new StorageList();
            }
            list.add(item);
            return list;
        }

        @Override
        protected List<E> getListFromListable(StorageList<E> list) {
            return list;
        }
    }

    private static abstract class MapObjectBinner<K, E, L>
    implements ObjectBinner<K, E> {
        private final Map<K, L> map_ = new HashMap<K, L>();
        private long nItem_;

        private MapObjectBinner() {
        }

        @Override
        public void addItem(K key, E item) {
            ++this.nItem_;
            this.map_.put(key, this.addToListable(this.map_.get(key), item));
        }

        @Override
        public List<E> getList(K key) {
            return this.getListFromListable(this.map_.get(key));
        }

        @Override
        public boolean containsKey(K key) {
            return this.map_.containsKey(key);
        }

        @Override
        public void remove(K key) {
            this.map_.remove(key);
        }

        @Override
        public Iterator<K> getKeyIterator() {
            return this.map_.keySet().iterator();
        }

        @Override
        public long getItemCount() {
            return this.nItem_;
        }

        @Override
        public long getBinCount() {
            return this.map_.size();
        }

        @Override
        public void addContent(ObjectBinner<K, E> other) {
            Iterator<K> keyIt = other.getKeyIterator();
            while (keyIt.hasNext()) {
                K key = keyIt.next();
                for (E item : other.getList(key)) {
                    this.addItem(key, item);
                }
            }
        }

        protected abstract L addToListable(L var1, E var2);

        protected abstract List<E> getListFromListable(L var1);
    }
}

