/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import uk.ac.starlink.table.join.HealpixMask;
import uk.ac.starlink.util.IntList;

public class BitsetMask
implements HealpixMask {
    private final int order_;
    private final int npix_;
    private final BitSet flags_;
    public static final int DEFAULT_ORDER = 6;

    public BitsetMask() {
        this(6);
    }

    public BitsetMask(int order) {
        this.order_ = order;
        long npixl = 12L << 2 * order;
        this.npix_ = (int)npixl;
        if ((long)this.npix_ != npixl) {
            throw new IllegalArgumentException("Order too high");
        }
        this.flags_ = new BitSet(this.npix_);
    }

    @Override
    public boolean isEmpty() {
        return this.flags_.isEmpty();
    }

    @Override
    public void intersection(HealpixMask other) {
        this.flags_.and(((BitsetMask)other).flags_);
    }

    @Override
    public void union(HealpixMask other) {
        this.flags_.or(((BitsetMask)other).flags_);
    }

    @Override
    public double getSkyFraction() {
        return (double)this.flags_.cardinality() * 1.0 / (double)this.npix_;
    }

    @Override
    public void addPixel(int order, long ipix) {
        int pixOrder = order;
        int maskOrder = this.order_;
        if (pixOrder == maskOrder) {
            this.flags_.set((int)ipix);
        } else if (pixOrder > maskOrder) {
            this.flags_.set((int)(ipix >> 2 * (pixOrder - maskOrder)));
        } else {
            assert (maskOrder > pixOrder);
            int shift = 2 * (maskOrder - pixOrder);
            int iplo = (int)(ipix << shift);
            int iphi = (int)(ipix + 1L << shift);
            this.flags_.set(iplo, iphi);
        }
    }

    @Override
    public HealpixMask.PixelTester createPixelTester() {
        int maskOrder = this.order_;
        BitSet flags = (BitSet)this.flags_.clone();
        return (pixOrder, ipix) -> {
            if (pixOrder == maskOrder) {
                return flags.get((int)ipix);
            }
            if (pixOrder > maskOrder) {
                return flags.get((int)(ipix >> 2 * (pixOrder - maskOrder)));
            }
            assert (maskOrder > pixOrder);
            int shift = 2 * (maskOrder - pixOrder);
            int iplo = (int)(ipix << shift);
            int iphi = (int)(ipix + 1L << shift);
            int nextSet = flags.nextSetBit(iplo);
            return nextSet >= 0 && nextSet < iphi;
        };
    }

    public int getOrder() {
        return this.order_;
    }

    public int[] getPixels() {
        IntList list = new IntList();
        int ib = this.flags_.nextSetBit(0);
        while (ib >= 0) {
            list.add(ib);
            if (ib == Integer.MAX_VALUE) break;
            ib = this.flags_.nextSetBit(ib + 1);
        }
        return list.toIntArray();
    }

    void writeEcsv(OutputStream out) throws IOException {
        PrintStream pout = new PrintStream(out);
        String colname = "hpx" + this.order_;
        pout.println("# %ECSV 1.0");
        pout.println("# ---");
        pout.println("# datatype: [{name: " + colname + ", datatype: int32}]");
        pout.println(colname);
        int i = this.flags_.nextSetBit(0);
        while (i >= 0) {
            pout.println(Integer.toString(i));
            i = this.flags_.nextSetBit(i + 1);
        }
    }
}

