/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.util.SplitCollector;
import uk.ac.starlink.util.SplitPolicy;
import uk.ac.starlink.util.SplitProcessor;
import uk.ac.starlink.util.Splittable;

public class CollectionRunner<E> {
    private final SplitProcessor<SpliteratorSplittable<E>> processor_;
    private static final int BLOCK_SIZE = 10000;
    public static final CollectionRunner<?> SEQUENTIAL = new CollectionRunner(SplitProcessor.createSequentialProcessor());
    public static final CollectionRunner<?> DFLT = new CollectionRunner(SplitProcessor.createBasicParallelProcessor(SplitPolicy.DFLT_POLICY));

    public CollectionRunner() {
        this(SplitProcessor.createBasicParallelProcessor(SplitPolicy.DFLT_POLICY));
    }

    public CollectionRunner(SplitProcessor<?> processor) {
        SplitProcessor<?> cProcessor = processor;
        this.processor_ = cProcessor;
    }

    public SplitProcessor<?> getSplitProcessor() {
        return this.processor_;
    }

    public <A> A collect(ElementCollector<E, A> collector, Collection<E> collection) {
        return this.collect(collector, collection, null);
    }

    public <A> A collect(final ElementCollector<E, A> collector, Collection<E> collection, ProgressIndicator progger) {
        double size1 = 1.0 / (double)collection.size();
        final Tracker tracker = progger == null ? null : new Tracker(progger, collection.size());
        SplitCollector splitCollector = new SplitCollector<SpliteratorSplittable<E>, A>(){

            @Override
            public A createAccumulator() {
                return collector.createAccumulator();
            }

            @Override
            public void accumulate(SpliteratorSplittable<E> splittable, A acc) {
                Spliterator spliterator = splittable.spliterator_;
                Consumer<Object> accConsumer = e -> collector.accumulate(e, acc);
                int[] subCount = new int[1];
                Consumer<Object> consumer = tracker == null ? accConsumer : e -> {
                    accConsumer.accept(e);
                    subCount[0] = subCount[0] + 1;
                    if (subCount[0] >= 10000) {
                        tracker.addCount(subCount[0]);
                        subCount[0] = 0;
                    }
                };
                try {
                    spliterator.forEachRemaining(consumer);
                }
                catch (TrackerInterruptedException trackerInterruptedException) {
                    // empty catch block
                }
                if (subCount[0] > 0) {
                    tracker.addCount(subCount[0]);
                }
            }

            @Override
            public A combine(A acc1, A acc2) {
                return collector.combine(acc1, acc2);
            }
        };
        SpliteratorSplittable<E> splittable = new SpliteratorSplittable<E>(collection.spliterator());
        return this.processor_.collect(splitCollector, splittable);
    }

    public static <E, A> A collectStream(ElementCollector<E, A> collector, Stream<E> stream) {
        return (A)stream.collect(Collector.of(collector::createAccumulator, (acc, el) -> collector.accumulate(el, acc), collector::combine, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    }

    private static class TrackerInterruptedException
    extends RuntimeException {
        TrackerInterruptedException(InterruptedException e) {
            super("Interrupted", e);
        }
    }

    private static class Tracker {
        final ProgressIndicator progger_;
        final double size1_;
        final AtomicInteger count_;

        Tracker(ProgressIndicator progger, int size) {
            this.progger_ = progger;
            this.size1_ = size > 0 ? 1.0 / (double)size : 0.0;
            this.count_ = new AtomicInteger();
        }

        public void addCount(int inc) {
            try {
                this.progger_.setLevel((double)this.count_.addAndGet(inc) * this.size1_);
            }
            catch (InterruptedException e) {
                throw new TrackerInterruptedException(e);
            }
        }
    }

    private static class SpliteratorSplittable<E>
    implements Splittable<SpliteratorSplittable<E>> {
        private final Spliterator<E> spliterator_;

        public SpliteratorSplittable(Spliterator<E> spliterator) {
            this.spliterator_ = spliterator;
        }

        @Override
        public long splittableSize() {
            long size = this.spliterator_.estimateSize();
            return size == Long.MAX_VALUE ? -1L : size;
        }

        @Override
        public SpliteratorSplittable<E> split() {
            Spliterator<E> subSpliterator = this.spliterator_.trySplit();
            return subSpliterator == null ? null : new SpliteratorSplittable<E>(subSpliterator);
        }
    }

    public static interface ElementCollector<E, A> {
        public A createAccumulator();

        public void accumulate(E var1, A var2);

        public A combine(A var1, A var2);
    }
}

