/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchKit;

public class CombinedMatchEngine
implements MatchEngine {
    private final boolean inSphere_;
    private final MatchEngine[] engines_;
    private final int[] tupleSizes_;
    private final int[] tupleStarts_;
    private final int nPart_;
    private String name_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between points in combined space");

    public CombinedMatchEngine(MatchEngine[] engines) {
        this(engines, false);
    }

    public CombinedMatchEngine(MatchEngine[] engines, boolean inSphere) {
        this.inSphere_ = inSphere;
        this.engines_ = engines;
        this.nPart_ = engines.length;
        this.tupleSizes_ = new int[this.nPart_];
        this.tupleStarts_ = new int[this.nPart_];
        int ts = 0;
        for (int i = 0; i < this.nPart_; ++i) {
            this.tupleStarts_[i] = ts;
            this.tupleSizes_[i] = this.engines_[i].getTupleInfos().length;
            ts += this.tupleSizes_[i];
        }
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < this.nPart_; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.engines_[i].toString());
        }
        buf.append(")");
        this.name_ = buf.toString();
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        boolean inSphere = this.inSphere_;
        int[] tupleStarts = (int[])this.tupleStarts_.clone();
        int[] tupleSizes = (int[])this.tupleSizes_.clone();
        ArrayList<Supplier<MatchKit>> kitFacts = new ArrayList<Supplier<MatchKit>>(this.nPart_);
        double[] scales = new double[this.nPart_];
        for (int i = 0; i < this.nPart_; ++i) {
            kitFacts.add(this.engines_[i].createMatchKitFactory());
            scales[i] = this.engines_[i].getScoreScale();
        }
        return () -> {
            MatchKit[] subKits = new MatchKit[this.nPart_];
            for (int i = 0; i < this.nPart_; ++i) {
                subKits[i] = (MatchKit)((Supplier)kitFacts.get(i)).get();
            }
            return new CombinedMatchKit(subKits, scales, inSphere, tupleStarts, tupleSizes);
        };
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        int[] tupleStarts = (int[])this.tupleStarts_.clone();
        int[] tupleSizes = (int[])this.tupleSizes_.clone();
        ArrayList<Supplier<Coverage>> subFacts = new ArrayList<Supplier<Coverage>>(this.nPart_);
        for (int i = 0; i < this.nPart_; ++i) {
            subFacts.add(this.engines_[i].createCoverageFactory());
        }
        return () -> {
            Coverage[] subCovs = new Coverage[this.nPart_];
            for (int i = 0; i < this.nPart_; ++i) {
                subCovs[i] = (Coverage)((Supplier)subFacts.get(i)).get();
            }
            return new CombinedCoverage(subCovs, tupleStarts, tupleSizes);
        };
    }

    @Override
    public double getScoreScale() {
        for (int i = 0; i < this.nPart_; ++i) {
            if (this.engines_[i].getScoreScale() > 0.0) continue;
            return Double.NaN;
        }
        return Math.sqrt(this.nPart_);
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        int nargs = this.tupleStarts_[this.nPart_ - 1] + this.tupleSizes_[this.nPart_ - 1];
        ValueInfo[] infos = new ValueInfo[nargs];
        for (int i = 0; i < this.nPart_; ++i) {
            System.arraycopy(this.engines_[i].getTupleInfos(), 0, infos, this.tupleStarts_[i], this.tupleSizes_[i]);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        for (int i = 0; i < this.nPart_; ++i) {
            params.addAll(Arrays.asList(this.engines_[i].getMatchParameters()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        for (int i = 0; i < this.nPart_; ++i) {
            params.addAll(Arrays.asList(this.engines_[i].getTuningParameters()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String toString() {
        return this.name_;
    }

    private static class CombinedCoverage
    implements Coverage {
        private final Coverage[] subCoverages_;
        private final int[] tupleStarts_;
        private final int[] tupleSizes_;
        private final int nPart_;
        private final Object[][] work_;

        public CombinedCoverage(Coverage[] subCoverages, int[] tupleStarts, int[] tupleSizes) {
            this.subCoverages_ = subCoverages;
            this.tupleStarts_ = tupleStarts;
            this.tupleSizes_ = tupleSizes;
            this.nPart_ = subCoverages.length;
            this.work_ = CombinedCoverage.createWorkspace(tupleSizes);
        }

        @Override
        public boolean isEmpty() {
            for (Coverage cov : this.subCoverages_) {
                if (!cov.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void extend(Object[] tuple) {
            for (int i = 0; i < this.nPart_; ++i) {
                Object[] subTuple = this.work_[i];
                int tStart = this.tupleStarts_[i];
                int tSize = this.tupleSizes_[i];
                System.arraycopy(tuple, tStart, subTuple, 0, tSize);
                this.subCoverages_[i].extend(subTuple);
            }
        }

        @Override
        public Supplier<Predicate<Object[]>> createTestFactory() {
            int[] tupleStarts = (int[])this.tupleStarts_.clone();
            int[] tupleSizes = (int[])this.tupleSizes_.clone();
            ArrayList<Supplier<Predicate<Object[]>>> subTestFacts = new ArrayList<Supplier<Predicate<Object[]>>>();
            for (int i = 0; i < this.nPart_; ++i) {
                subTestFacts.add(this.subCoverages_[i].createTestFactory());
            }
            return () -> {
                Object[][] work = CombinedCoverage.createWorkspace(tupleSizes);
                ArrayList subTests = new ArrayList();
                for (int i = 0; i < this.nPart_; ++i) {
                    subTests.add(((Supplier)subTestFacts.get(i)).get());
                }
                return tuple -> {
                    for (int i = 0; i < this.nPart_; ++i) {
                        Object[] subTuple = work[i];
                        int tStart = tupleStarts[i];
                        int tSize = tupleSizes[i];
                        System.arraycopy(tuple, tStart, subTuple, 0, tSize);
                        if (((Predicate)subTests.get(i)).test(subTuple)) continue;
                        return false;
                    }
                    return true;
                };
            };
        }

        @Override
        public void intersection(Coverage other) {
            Coverage[] otherSubcovs = ((CombinedCoverage)other).subCoverages_;
            for (int i = 0; i < this.nPart_; ++i) {
                this.subCoverages_[i].intersection(otherSubcovs[i]);
            }
        }

        @Override
        public void union(Coverage other) {
            Coverage[] otherSubcovs = ((CombinedCoverage)other).subCoverages_;
            for (int i = 0; i < this.nPart_; ++i) {
                this.subCoverages_[i].union(otherSubcovs[i]);
            }
        }

        @Override
        public String coverageText() {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("(");
            for (int i = 0; i < this.nPart_; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(this.subCoverages_[i].coverageText());
            }
            sbuf.append(")");
            return sbuf.toString();
        }

        private static Object[][] createWorkspace(int[] tupleSizes) {
            int nPart = tupleSizes.length;
            Object[][] work = new Object[nPart][];
            for (int i = 0; i < nPart; ++i) {
                work[i] = new Object[tupleSizes[i]];
            }
            return work;
        }
    }

    private static class CombinedMatchKit
    implements MatchKit {
        final MatchKit[] subKits_;
        final double[] scales_;
        final boolean inSphere_;
        final int[] tupleStarts_;
        final int[] tupleSizes_;
        final int nPart_;
        final Object[][] work0_;
        final Object[][] work1_;
        final Object[][] work2_;

        CombinedMatchKit(MatchKit[] subKits, double[] scales, boolean inSphere, int[] tupleStarts, int[] tupleSizes) {
            this.subKits_ = subKits;
            this.scales_ = scales;
            this.inSphere_ = inSphere;
            this.tupleStarts_ = tupleStarts;
            this.tupleSizes_ = tupleSizes;
            this.nPart_ = subKits.length;
            this.work0_ = new Object[this.nPart_][];
            this.work1_ = new Object[this.nPart_][];
            this.work2_ = new Object[this.nPart_][];
            for (int i = 0; i < this.nPart_; ++i) {
                int ts = tupleSizes[i];
                this.work0_[i] = new Object[ts];
                this.work1_[i] = new Object[ts];
                this.work2_[i] = new Object[ts];
            }
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            double sum2 = 0.0;
            for (int i = 0; i < this.nPart_; ++i) {
                Object[] subTuple1 = this.work1_[i];
                Object[] subTuple2 = this.work2_[i];
                int tStart = this.tupleStarts_[i];
                int tSize = this.tupleSizes_[i];
                System.arraycopy(tuple1, tStart, subTuple1, 0, tSize);
                System.arraycopy(tuple2, tStart, subTuple2, 0, tSize);
                double score = this.subKits_[i].matchScore(subTuple1, subTuple2);
                if (score < 0.0) {
                    return -1.0;
                }
                double scale = this.scales_[i];
                double d1 = scale > 0.0 ? score / scale : score;
                sum2 += d1 * d1;
            }
            double sum1 = Math.sqrt(sum2);
            if (this.inSphere_) {
                return sum1 <= 1.0 ? sum1 : -1.0;
            }
            return sum1;
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            Object[][] binBag = new Object[this.nPart_][];
            for (int i = 0; i < this.nPart_; ++i) {
                Object[] subTuple = this.work0_[i];
                System.arraycopy(tuple, this.tupleStarts_[i], subTuple, 0, this.tupleSizes_[i]);
                binBag[i] = this.subKits_[i].getBins(subTuple);
            }
            int nBin = 1;
            for (int i = 0; i < this.nPart_; ++i) {
                nBin *= binBag[i].length;
            }
            Object[] bins = new Object[nBin];
            int[] offset = new int[this.nPart_];
            block2: for (int ibin = 0; ibin < nBin; ++ibin) {
                ArrayList<Object> bin = new ArrayList<Object>(this.nPart_);
                for (int i = 0; i < this.nPart_; ++i) {
                    bin.add(binBag[i][offset[i]]);
                }
                bins[ibin] = bin;
                for (int j = 0; j < this.nPart_; ++j) {
                    int n = j;
                    offset[n] = offset[n] + 1;
                    if (offset[n] < binBag[j].length) continue block2;
                    offset[j] = 0;
                }
            }
            for (int i = 0; i < this.nPart_; ++i) {
                assert (offset[i] == 0);
            }
            return bins;
        }
    }
}

