/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.join.Coverage;

public abstract class CuboidCoverage
implements Coverage {
    final int ndim_;
    final double[] mins_;
    final double[] maxs_;

    protected CuboidCoverage(int ndim) {
        this.ndim_ = ndim;
        this.mins_ = new double[ndim];
        this.maxs_ = new double[ndim];
        this.setEmpty();
    }

    @Override
    public boolean isEmpty() {
        for (int idim = 0; idim < this.ndim_; ++idim) {
            if (!(this.mins_[idim] > this.maxs_[idim])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void union(Coverage other) {
        CuboidCoverage cother = (CuboidCoverage)other;
        for (int idim = 0; idim < this.ndim_; ++idim) {
            this.mins_[idim] = Math.min(this.mins_[idim], cother.mins_[idim]);
            this.maxs_[idim] = Math.max(this.maxs_[idim], cother.maxs_[idim]);
        }
    }

    @Override
    public void intersection(Coverage other) {
        CuboidCoverage cother = (CuboidCoverage)other;
        for (int idim = 0; idim < this.ndim_; ++idim) {
            this.mins_[idim] = Math.max(this.mins_[idim], cother.mins_[idim]);
            this.maxs_[idim] = Math.min(this.maxs_[idim], cother.maxs_[idim]);
            if (this.mins_[idim] <= this.maxs_[idim]) continue;
            this.setEmpty();
            return;
        }
    }

    @Override
    public String coverageText() {
        if (this.isEmpty()) {
            return "none";
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.ndim_; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(Float.toString((float)this.mins_[i])).append(" .. ").append(Float.toString((float)this.maxs_[i]));
        }
        return sbuf.toString();
    }

    private void setEmpty() {
        for (int idim = 0; idim < this.ndim_; ++idim) {
            this.mins_[idim] = Double.POSITIVE_INFINITY;
            this.maxs_[idim] = Double.NEGATIVE_INFINITY;
        }
        assert (this.isEmpty());
    }

    public static CuboidCoverage createFixedCartesianCoverage(int ndim, double err) {
        double[] errs = new double[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            errs[idim] = err >= 0.0 ? err : 0.0;
        }
        return CuboidCoverage.createFixedCartesianCoverage(ndim, errs);
    }

    public static CuboidCoverage createFixedCartesianCoverage(int ndim, double[] errs) {
        return CuboidCoverage.createFixedErrorCoverage(ndim, errs, CuboidCoverage.createCartesianPointDecoder(ndim));
    }

    public static CuboidCoverage createFixedErrorCoverage(final int ndim, double[] errors, final PointDecoder pointDecoder) {
        final double[] errs = new double[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            errs[idim] = errors[idim] >= 0.0 ? errors[idim] : 0.0;
        }
        return new CuboidCoverage(ndim){
            final double[] point_;
            {
                super(ndim2);
                this.point_ = new double[ndim];
            }

            @Override
            public void extend(Object[] tuple) {
                if (pointDecoder.decodePoint(tuple, this.point_)) {
                    for (int idim = 0; idim < ndim; ++idim) {
                        double p = this.point_[idim];
                        double err = errs[idim];
                        this.mins_[idim] = Math.min(this.mins_[idim], p - err);
                        this.maxs_[idim] = Math.max(this.maxs_[idim], p + err);
                    }
                }
            }

            @Override
            public Supplier<Predicate<Object[]>> createTestFactory() {
                double[] mins = (double[])this.mins_.clone();
                double[] maxs = (double[])this.maxs_.clone();
                return () -> {
                    double[] point = new double[ndim];
                    return tuple -> {
                        if (pointDecoder.decodePoint((Object[])tuple, point)) {
                            for (int idim = 0; idim < ndim; ++idim) {
                                double p = point[idim];
                                if (p >= mins[idim] && p <= maxs[idim]) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    };
                };
            }
        };
    }

    public static CuboidCoverage createVariableErrorCoverage(final int ndim, final PointDecoder pointDecoder, final ErrorDecoder errorDecoder) {
        return new CuboidCoverage(ndim){
            final double[] point_;
            {
                super(ndim2);
                this.point_ = new double[ndim];
            }

            @Override
            public void extend(Object[] tuple) {
                if (pointDecoder.decodePoint(tuple, this.point_)) {
                    double err = errorDecoder.decodeError(tuple);
                    err = err >= 0.0 ? err : 0.0;
                    for (int idim = 0; idim < this.ndim_; ++idim) {
                        double p = this.point_[idim];
                        this.mins_[idim] = Math.min(this.mins_[idim], p - err);
                        this.maxs_[idim] = Math.max(this.maxs_[idim], p + err);
                    }
                }
            }

            @Override
            public Supplier<Predicate<Object[]>> createTestFactory() {
                double[] mins = (double[])this.mins_.clone();
                double[] maxs = (double[])this.maxs_.clone();
                return () -> {
                    double[] point = new double[ndim];
                    return tuple -> {
                        if (pointDecoder.decodePoint((Object[])tuple, point)) {
                            double err = errorDecoder.decodeError((Object[])tuple);
                            err = err >= 0.0 ? err : 0.0;
                            for (int idim = 0; idim < ndim; ++idim) {
                                double p = point[idim];
                                if (p + err >= mins[idim] && p - err <= maxs[idim]) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    };
                };
            }
        };
    }

    public static PointDecoder createCartesianPointDecoder(int ndim) {
        return (tuple, point) -> {
            for (int idim = 0; idim < ndim; ++idim) {
                double dval;
                Object val = tuple[idim];
                if (val instanceof Number) {
                    dval = ((Number)val).doubleValue();
                    if (!Double.isFinite(dval)) {
                        return false;
                    }
                } else {
                    return false;
                }
                point[idim] = dval;
            }
            return true;
        };
    }

    @FunctionalInterface
    public static interface ErrorDecoder {
        public double decodeError(Object[] var1);
    }

    @FunctionalInterface
    public static interface PointDecoder {
        public boolean decodePoint(Object[] var1, double[] var2);
    }
}

