/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

public enum ErrorSummation {
    SIMPLE("simple addition", ""){

        @Override
        public double combine(double e1, double e2) {
            return e1 + e2;
        }

        @Override
        public double combineSquared(double e1, double e2) {
            double c = e1 + e2;
            return c * c;
        }
    }
    ,
    QUADRATURE("addition in quadrature", " in quadrature"){

        @Override
        public double combine(double e1, double e2) {
            return Math.hypot(e1, e2);
        }

        @Override
        public double combineSquared(double e1, double e2) {
            return e1 * e1 + e2 * e2;
        }
    };

    private final String description_;
    private final String tail_;

    private ErrorSummation(String description, String tail) {
        this.description_ = description;
        this.tail_ = tail;
    }

    public abstract double combine(double var1, double var3);

    public abstract double combineSquared(double var1, double var3);

    public String getDescription() {
        return this.description_;
    }

    public String getTail() {
        return this.tail_;
    }
}

