/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.CollectionRunner;
import uk.ac.starlink.table.join.LinkGroup;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressTracker;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowLinkTable;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.util.SplitProcessor;

public class MatchStarTables {
    private final ProgressIndicator indicator_;
    private final CollectionRunner<RowLink> linkRunner_;
    private static final CollectionRunner<RowLink> SEQ_RUNNER = new CollectionRunner(SplitProcessor.createSequentialProcessor());
    public static final ValueInfo GRP_ID_INFO = new DefaultValueInfo("GroupID", Integer.class, "ID for match group");
    public static final ValueInfo GRP_SIZE_INFO = new DefaultValueInfo("GroupSize", Integer.class, "Number of rows in match group");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.join");

    public MatchStarTables() {
        this(null, null);
    }

    public MatchStarTables(ProgressIndicator indicator, SplitProcessor<?> splitProcessor) {
        if (indicator == null) {
            indicator = new NullProgressIndicator();
        }
        if (splitProcessor == null) {
            splitProcessor = RowRunner.DEFAULT.getSplitProcessor();
        }
        this.indicator_ = indicator;
        this.linkRunner_ = new CollectionRunner(splitProcessor);
    }

    public StarTable makeJoinTable(StarTable[] tables, Collection<RowLink> rowLinks, boolean addGroups, JoinFixAction[] fixActs, ValueInfo matchScoreInfo) throws InterruptedException {
        double[] scores;
        int nTable = tables.length;
        int nRow = rowLinks.size();
        long[][] rowIndices = new long[nTable][];
        for (int iTable = 0; iTable < nTable; ++iTable) {
            if (tables[iTable] == null) continue;
            rowIndices[iTable] = new long[nRow];
            Arrays.fill(rowIndices[iTable], -1L);
        }
        if (matchScoreInfo != null) {
            try {
                scores = new double[nRow];
                Arrays.fill(scores, Double.NaN);
            }
            catch (OutOfMemoryError e) {
                scores = null;
                logger_.warning("Out of memory calculating match scores - no " + matchScoreInfo.getName() + " column in output");
            }
        } else {
            scores = null;
        }
        int nScore = 0;
        Map<RowLink, LinkGroup> grpMap = null;
        int[] grpSizes = null;
        int[] grpIds = null;
        if (addGroups) {
            try {
                grpMap = this.findGroups(rowLinks);
                if (grpMap.size() > 0) {
                    grpSizes = new int[nRow];
                    grpIds = new int[nRow];
                } else {
                    grpMap = null;
                }
            }
            catch (OutOfMemoryError e) {
                grpMap = null;
                grpSizes = null;
                grpIds = null;
                logger_.warning("Out of memory calculating match groups - no " + GRP_ID_INFO.getName() + " or " + GRP_SIZE_INFO.getName() + " columns in output");
            }
        }
        int iLink = 0;
        HashMap<Integer, Integer> idMap = new HashMap<Integer, Integer>();
        int[] iGrp = new int[1];
        ProgressTracker imTracker = new ProgressTracker(this.indicator_, rowLinks.size(), "Populate index maps");
        for (RowLink link : rowLinks) {
            LinkGroup grp;
            double score;
            int nref = link.size();
            for (int i2 = 0; i2 < nref; ++i2) {
                RowRef ref = link.getRef(i2);
                int iTable = ref.getTableIndex();
                if (tables[iTable] == null) continue;
                rowIndices[iTable][iLink] = ref.getRowIndex();
            }
            if (scores != null && link instanceof RowLink2 && !Double.isNaN(score = ((RowLink2)link).getScore())) {
                scores[iLink] = score;
                ++nScore;
            }
            if (grpMap != null && (grp = grpMap.get(link)) != null) {
                int id;
                grpIds[iLink] = id = idMap.computeIfAbsent(grp.getID(), i -> {
                    iGrp[0] = iGrp[0] + 1;
                    return iGrp[0];
                }).intValue();
                grpSizes[iLink] = grp.getSize();
            }
            ++iLink;
            imTracker.nextProgress();
        }
        imTracker.close();
        assert (iLink == nRow);
        ArrayList<StarTable> subTableList = new ArrayList<StarTable>();
        ArrayList<JoinFixAction> fixActList = new ArrayList<JoinFixAction>();
        for (int iTable = 0; iTable < nTable; ++iTable) {
            StarTable table = tables[iTable];
            if (table == null) continue;
            long[] rowIxs = rowIndices[iTable];
            int nCol = table.getColumnCount();
            final ColumnInfo[] colInfos = new ColumnInfo[nCol];
            for (int iCol = 0; iCol < nCol; ++iCol) {
                colInfos[iCol] = new ColumnInfo(table.getColumnInfo(iCol));
            }
            boolean hasBlankRows = false;
            for (int iRow = 0; iRow < nRow; ++iRow) {
                hasBlankRows = hasBlankRows || rowIxs[iRow] < 0L;
            }
            if (hasBlankRows) {
                for (int iCol = 0; iCol < nCol; ++iCol) {
                    colInfos[iCol].setNullable(true);
                }
            }
            RowPermutedStarTable subTable = new RowPermutedStarTable(table, rowIxs){

                @Override
                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
            subTableList.add(subTable);
            fixActList.add(fixActs[iTable]);
        }
        ArrayList<ColumnData> extraCols = new ArrayList<ColumnData>();
        if (grpMap != null) {
            ColumnInfo grpIdInfo = new ColumnInfo(GRP_ID_INFO);
            ColumnInfo grpSizeInfo = new ColumnInfo(GRP_SIZE_INFO);
            final int[] grpIdData = grpIds;
            final int[] grpSizeData = grpSizes;
            assert (grpIdData != null);
            assert (grpSizeData != null);
            extraCols.add(new ColumnData(GRP_ID_INFO){

                @Override
                public Object readValue(long lrow) {
                    int irow;
                    if (lrow < Integer.MAX_VALUE && grpSizeData[irow = (int)lrow] > 1) {
                        return grpIdData[irow];
                    }
                    return null;
                }
            });
            extraCols.add(new ColumnData(GRP_SIZE_INFO){

                @Override
                public Object readValue(long lrow) {
                    int irow;
                    if (lrow < Integer.MAX_VALUE && grpSizeData[irow = (int)lrow] > 1) {
                        return grpSizeData[irow];
                    }
                    return null;
                }
            });
        }
        if (matchScoreInfo != null && scores != null) {
            extraCols.add(ArrayColumn.makeColumn(new ColumnInfo(matchScoreInfo), (Object)scores));
        }
        if (extraCols.size() > 0) {
            ColumnStarTable extraTable = ColumnStarTable.makeTableWithRows(nRow);
            for (ColumnData cdata : extraCols) {
                extraTable.addColumn(cdata);
            }
            subTableList.add(extraTable);
            fixActList.add(JoinFixAction.NO_ACTION);
        }
        StarTable[] subTables = subTableList.toArray(new StarTable[0]);
        JoinFixAction[] subFixes = fixActList.toArray(new JoinFixAction[0]);
        JoinStarTable joined = new JoinStarTable(subTables, subFixes);
        joined.setName("Joined");
        return joined;
    }

    public static StarTable makeSequentialJoinTable(StarTable[] tables, final Collection<RowLink> rowLinks, JoinFixAction[] fixActs, ValueInfo matchScoreInfo) {
        ArrayList<StarTable> subTableList = new ArrayList<StarTable>();
        ArrayList<JoinFixAction> fixActList = new ArrayList<JoinFixAction>();
        for (int iTable = 0; iTable < tables.length; ++iTable) {
            StarTable table = tables[iTable];
            subTableList.add(new RowLinkTable(table, iTable){

                @Override
                public Iterator<RowLink> getLinkIterator() {
                    return rowLinks.iterator();
                }
            });
            fixActList.add(fixActs[iTable]);
        }
        if (matchScoreInfo != null) {
            final ColumnInfo matchInfo = new ColumnInfo(matchScoreInfo);
            AbstractStarTable matchTable = new AbstractStarTable(){

                @Override
                public ColumnInfo getColumnInfo(int icol) {
                    return icol == 0 ? matchInfo : null;
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public long getRowCount() {
                    return -1L;
                }

                @Override
                public RowSequence getRowSequence() {
                    final Iterator linkIt = rowLinks.iterator();
                    return new RowSequence(){
                        RowLink link_;

                        @Override
                        public boolean next() {
                            if (linkIt.hasNext()) {
                                this.link_ = (RowLink)linkIt.next();
                                return true;
                            }
                            this.link_ = null;
                            return false;
                        }

                        @Override
                        public Object getCell(int icol) {
                            return this.getScore();
                        }

                        @Override
                        public Object[] getRow() {
                            return new Object[]{this.getScore()};
                        }

                        @Override
                        public void close() {
                        }

                        private Double getScore() {
                            double score;
                            if (this.link_ instanceof RowLink2 && !Double.isNaN(score = ((RowLink2)this.link_).getScore())) {
                                return score;
                            }
                            return null;
                        }
                    };
                }
            };
            subTableList.add(matchTable);
            fixActList.add(JoinFixAction.NO_ACTION);
        }
        StarTable[] subTables = subTableList.toArray(new RowLinkTable[0]);
        JoinFixAction[] subFixes = fixActList.toArray(new JoinFixAction[0]);
        JoinStarTable joined = new JoinStarTable(subTables, subFixes);
        joined.setName("Joined");
        return joined;
    }

    public static StarTable makeInternalMatchTable(int iTable, Collection<RowLink> rowLinks, long rowCount) {
        final int nrow = Tables.checkedLongToInt(rowCount);
        final int[] grpIds = new int[nrow];
        final int[] grpSizes = new int[nrow];
        int grpId = 0;
        for (RowLink link : rowLinks) {
            ++grpId;
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                long lrow = ref.getRowIndex();
                int irow = Tables.checkedLongToInt(lrow);
                grpIds[irow] = grpId;
                int n = grpId;
                grpSizes[n] = grpSizes[n] + 1;
            }
        }
        ColumnData grpIdColumn = new ColumnData(GRP_ID_INFO){

            @Override
            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? Integer.valueOf(grpId) : null;
            }
        };
        ColumnData grpSizeColumn = new ColumnData(GRP_SIZE_INFO){

            @Override
            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? Integer.valueOf(grpSizes[grpId]) : null;
            }
        };
        ColumnStarTable grpTable = ColumnStarTable.makeTableWithRows(nrow);
        grpTable.addColumn(grpIdColumn);
        grpTable.addColumn(grpSizeColumn);
        return grpTable;
    }

    public Map<RowLink, LinkGroup> findGroups(Collection<RowLink> links) throws InterruptedException {
        boolean idrefParallel = false;
        this.indicator_.startStage("Identify shared refs");
        Map<RowRef, Token> refMap = (idrefParallel ? this.linkRunner_ : SEQ_RUNNER).collect(new RefTokenCollector(), links, this.indicator_);
        this.indicator_.endStage();
        Iterator<Token> it = refMap.values().iterator();
        while (it.hasNext()) {
            Token token = it.next();
            if (token.getGroupSize() != 1) continue;
            it.remove();
        }
        HashMap<RowRef, LinkGroup> refMapGrp = new HashMap<RowRef, LinkGroup>();
        HashMap<Integer, LinkGroup> knownGroups = new HashMap<Integer, LinkGroup>();
        Iterator<Map.Entry<RowRef, Token>> it2 = refMap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<RowRef, Token> entry = it2.next();
            RowRef ref = entry.getKey();
            Token token = entry.getValue();
            int grpSize = token.getGroupSize();
            assert (grpSize > 1);
            int id = token.getGroupId();
            Integer groupKey = id;
            if (!knownGroups.containsKey(groupKey)) {
                knownGroups.put(groupKey, new LinkGroup(id, grpSize));
            }
            LinkGroup group = (LinkGroup)knownGroups.get(groupKey);
            refMapGrp.put(ref, group);
            it2.remove();
        }
        assert (refMap.size() == 0);
        refMap = null;
        knownGroups = null;
        boolean grpParallel = true;
        this.indicator_.startStage("Map links to groups");
        Map<RowLink, LinkGroup> result = (grpParallel ? this.linkRunner_ : SEQ_RUNNER).collect(new GroupCollector(refMapGrp), links, this.indicator_);
        this.indicator_.endStage();
        return result;
    }

    public static Collection<RowLink> orderLinks(final LinkSet linkSet) {
        try {
            return linkSet.toSorted();
        }
        catch (OutOfMemoryError e) {
            logger_.log(Level.WARNING, "Can't sort matches - matched table rows may be in an unhelpful order", e);
            return new AbstractCollection<RowLink>(){

                @Override
                public int size() {
                    return linkSet.size();
                }

                @Override
                public Iterator<RowLink> iterator() {
                    return linkSet.iterator();
                }
            };
        }
    }

    public static MatchStarTables createInstance(ProgressIndicator indicator, RowRunner rowRunner) {
        SplitProcessor<RowSplittable> splitProcessor = rowRunner == null ? null : rowRunner.getSplitProcessor();
        return new MatchStarTables(indicator, splitProcessor);
    }

    private static class GroupCollector
    implements CollectionRunner.ElementCollector<RowLink, Map<RowLink, LinkGroup>> {
        final Map<RowRef, LinkGroup> refMapGrp_;

        GroupCollector(Map<RowRef, LinkGroup> refMapGrp) {
            this.refMapGrp_ = refMapGrp;
        }

        @Override
        public Map<RowLink, LinkGroup> createAccumulator() {
            return new HashMap<RowLink, LinkGroup>();
        }

        @Override
        public Map<RowLink, LinkGroup> combine(Map<RowLink, LinkGroup> map1, Map<RowLink, LinkGroup> map2) {
            if (map1.size() > map2.size()) {
                map1.putAll(map2);
                return map1;
            }
            map2.putAll(map1);
            return map2;
        }

        @Override
        public void accumulate(RowLink link, Map<RowLink, LinkGroup> result) {
            RowRef ref0 = link.getRef(0);
            LinkGroup group = this.refMapGrp_.get(ref0);
            if (group != null) {
                result.put(link, group);
            }
            assert (this.refsInGroup(link, group));
        }

        private boolean refsInGroup(RowLink link, LinkGroup group) {
            for (int i = 0; i < link.size(); ++i) {
                if (group == this.refMapGrp_.get(link.getRef(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class RefTokenCollector
    implements CollectionRunner.ElementCollector<RowLink, Map<RowRef, Token>> {
        private final AtomicInteger tCounter_ = new AtomicInteger();

        RefTokenCollector() {
        }

        @Override
        public Map<RowRef, Token> createAccumulator() {
            return new HashMap<RowRef, Token>();
        }

        @Override
        public Map<RowRef, Token> combine(Map<RowRef, Token> map1, Map<RowRef, Token> map2) {
            boolean big1 = map1.size() >= map2.size();
            Map<RowRef, Token> mapA = big1 ? map1 : map2;
            Map<RowRef, Token> mapB = big1 ? map2 : map1;
            for (Map.Entry<RowRef, Token> entryB : mapB.entrySet()) {
                RowRef ref = entryB.getKey();
                Token tokenB = entryB.getValue();
                this.addToken(mapA, ref, tokenB);
            }
            return mapA;
        }

        @Override
        public void accumulate(RowLink link, Map<RowRef, Token> refMap) {
            Token linkToken = new Token(this.tCounter_.getAndIncrement());
            int nr = link.size();
            for (int i = 0; i < nr; ++i) {
                this.addToken(refMap, link.getRef(i), linkToken);
            }
        }

        private void addToken(Map<RowRef, Token> refMap, RowRef ref, Token linkToken) {
            if (refMap.containsKey(ref)) {
                refMap.get(ref).join(linkToken);
            } else {
                refMap.put(ref, linkToken);
            }
        }
    }

    private static class TokenGroup
    implements Iterable<Token> {
        private final Set<Token> set_ = new HashSet<Token>();
        private int minTokenId_ = Integer.MAX_VALUE;

        private TokenGroup() {
        }

        void add(Token token) {
            this.set_.add(token);
            this.minTokenId_ = Math.min(this.minTokenId_, token.id_);
        }

        boolean contains(Token token) {
            return this.set_.contains(token);
        }

        int size() {
            return this.set_.size();
        }

        int getId() {
            return this.minTokenId_;
        }

        @Override
        public Iterator<Token> iterator() {
            return this.set_.iterator();
        }
    }

    private static class Token
    implements Comparable<Token> {
        private final int id_;
        private TokenGroup group_;

        public Token(int id) {
            this.id_ = id;
        }

        public void join(Token other) {
            if (this.group_ == null && other.group_ == null) {
                this.group_ = new TokenGroup();
                this.group_.add(this);
                this.group_.add(other);
                other.group_ = this.group_;
            } else if (this.group_ == null && other.group_ != null) {
                other.group_.add(this);
                this.group_ = other.group_;
            } else if (this.group_ != null && other.group_ == null) {
                this.group_.add(other);
                other.group_ = this.group_;
            } else if (this.group_ != null && other.group_ != null) {
                assert (this.group_.contains(this));
                assert (other.group_.contains(other));
                if (this.group_ != other.group_) {
                    TokenGroup otherGroup = other.group_;
                    for (Token tok : other.group_) {
                        assert (tok.group_ == otherGroup);
                        assert (tok.group_ != this.group_);
                        this.group_.add(tok);
                        tok.group_ = this.group_;
                    }
                }
            } else assert (false);
            assert (this.group_ == other.group_);
        }

        public int getGroupId() {
            return this.group_ == null ? this.id_ : this.group_.getId();
        }

        public int getGroupSize() {
            return this.group_ == null ? 1 : this.group_.size();
        }

        public String toString() {
            return "token" + this.getGroupId() + "[" + this.getGroupSize() + "]-" + this.id_;
        }

        @Override
        public int compareTo(Token other) {
            if (this.id_ == other.id_) {
                return 0;
            }
            return this.id_ > other.id_ ? 1 : -1;
        }
    }
}

