/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

public class MultiJoinType {
    private final String name_;
    public static final MultiJoinType MATCH = new MultiJoinType("match");
    public static final MultiJoinType NOMATCH = new MultiJoinType("nomatch");
    public static final MultiJoinType ALWAYS = new MultiJoinType("always");
    public static final MultiJoinType DEFAULT = new MultiJoinType("default");

    private MultiJoinType(String name) {
        this.name_ = name;
    }

    public String toString() {
        return this.name_;
    }

    public static boolean accept(MultiJoinType[] joinTypes, boolean[] present) {
        int i;
        int n = joinTypes.length;
        if (present.length != n) {
            throw new IllegalArgumentException("Count mismatch");
        }
        for (i = 0; i < n; ++i) {
            if (joinTypes[i] == null) {
                throw new NullPointerException();
            }
            if (joinTypes[i] != ALWAYS || !present[i]) continue;
            return true;
        }
        for (i = 0; i < n; ++i) {
            if (joinTypes[i] == MATCH && !present[i]) {
                return false;
            }
            if (joinTypes[i] != NOMATCH || !present[i]) continue;
            return false;
        }
        return true;
    }
}

