/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.ProgressRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.join.Binners;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.MatchComputer;
import uk.ac.starlink.table.join.MatchKit;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowRef;

class ParallelMatchComputer
implements MatchComputer {
    private final RowRunner runner_;

    public ParallelMatchComputer(RowRunner runner) {
        this.runner_ = runner;
    }

    @Override
    public String getDescription() {
        return "Split, " + this.runner_.getSplitProcessor();
    }

    @Override
    public MatchComputer.BinnedRows binRowIndices(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable tableR, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        long nrowR = tableR.getRowCount();
        boolean isIntSizeR = nrowR >= 0L && nrowR < Integer.MAX_VALUE;
        BinCollector collector = new BinCollector(kitFact, isIntSizeR, rowSelector);
        return this.progressCollect(collector, tableR, indicator, stageTxt);
    }

    @Override
    public long binRowRefs(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable table, int tIndex, ObjectBinner<Object, RowRef> binner, boolean newBins, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        Predicate<Object> canAddKey = newBins ? key -> true : key -> binner.containsKey(key);
        Supplier<ObjectBinner<Object, RowRef>> binnerFactory = Binners::createObjectBinner;
        RefCollector collector = new RefCollector(kitFact, rowSelector, tIndex, canAddKey, binnerFactory);
        SplitBinnedRefs binned = this.progressCollect(collector, table, indicator, stageTxt);
        binner.addContent(binned.binner_);
        return binned.ninclude_;
    }

    @Override
    public LinkSet scanBinsForPairs(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable tableR, int indexR, StarTable tableS, int indexS, boolean bestOnly, LongBinner binnerR, Supplier<LinkSet> linksetCreator, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        PairCollector collector = new PairCollector(kitFact, indexR, indexS, rowSelector, bestOnly, tableR, binnerR, linksetCreator);
        return this.progressCollect(collector, tableS, indicator, stageTxt);
    }

    @Override
    public Coverage readCoverage(Supplier<Coverage> covFact, StarTable table, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        CoverageCollector collector = new CoverageCollector(covFact);
        return this.progressCollect(collector, table, indicator, stageTxt);
    }

    @Override
    public long countRows(StarTable table, Supplier<Predicate<Object[]>> rowSelector, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        CountCollector collector = new CountCollector(rowSelector);
        return this.progressCollect(collector, table, indicator, stageTxt)[0];
    }

    public <A> A progressCollect(RowCollector<A> collector, StarTable table, final ProgressIndicator indicator, final String msg) throws IOException {
        long nrow = table.getRowCount();
        final double rowFactor = nrow > 0L ? 1.0 / (double)nrow : 0.0;
        final ProgressRowSplittable.Target progTarget = new ProgressRowSplittable.Target(){

            @Override
            public void updateCount(long count) throws IOException {
                try {
                    indicator.setLevel((double)count * rowFactor);
                }
                catch (InterruptedException e) {
                    throw new IOException("Progress interrupted");
                }
            }

            @Override
            public void done(long count) {
                indicator.endStage();
            }
        };
        RowRunner progRunner = new RowRunner(this.runner_.getSplitProcessor()){

            @Override
            public RowSplittable createRowSplittable(StarTable table) throws IOException {
                RowSplittable baseSplit = ParallelMatchComputer.this.runner_.createRowSplittable(table);
                indicator.startStage(msg);
                return new ProgressRowSplittable(baseSplit, progTarget);
            }
        };
        return progRunner.collect(collector, table);
    }

    private static class CountCollector
    extends RowCollector<long[]> {
        private final Supplier<Predicate<Object[]>> rowSelector_;

        CountCollector(Supplier<Predicate<Object[]>> rowSelector) {
            this.rowSelector_ = rowSelector;
        }

        @Override
        public long[] createAccumulator() {
            return new long[]{0L};
        }

        @Override
        public long[] combine(long[] acc1, long[] acc2) {
            return new long[]{acc1[0] + acc2[0]};
        }

        @Override
        public void accumulateRows(RowSplittable rseq, long[] acc) throws IOException {
            Predicate<Object[]> inclusion = this.rowSelector_.get();
            long count = acc[0];
            while (rseq.next()) {
                if (!inclusion.test(rseq.getRow())) continue;
                ++count;
            }
            acc[0] = count;
        }
    }

    private static class CoverageCollector
    extends RowCollector<Coverage> {
        private final Supplier<Coverage> covFact_;

        CoverageCollector(Supplier<Coverage> covFact) {
            this.covFact_ = covFact;
        }

        @Override
        public Coverage createAccumulator() {
            return this.covFact_.get();
        }

        @Override
        public Coverage combine(Coverage cov1, Coverage cov2) {
            cov1.union(cov2);
            return cov1;
        }

        @Override
        public void accumulateRows(RowSplittable rseq, Coverage cov) throws IOException {
            while (rseq.next()) {
                cov.extend(rseq.getRow());
            }
        }
    }

    private static class PairCollector
    extends RowCollector<LinkSet> {
        private final Supplier<MatchKit> kitFact_;
        private final int indexR_;
        private final int indexS_;
        private final Supplier<Predicate<Object[]>> rowSelector_;
        private final boolean bestOnly_;
        private final StarTable tableR_;
        private final LongBinner binnerR_;
        private final Supplier<LinkSet> linksetCreator_;

        PairCollector(Supplier<MatchKit> kitFact, int indexR, int indexS, Supplier<Predicate<Object[]>> rowSelector, boolean bestOnly, StarTable tableR, LongBinner binnerR, Supplier<LinkSet> linksetCreator) {
            this.kitFact_ = kitFact;
            this.indexR_ = indexR;
            this.indexS_ = indexS;
            this.rowSelector_ = rowSelector;
            this.bestOnly_ = bestOnly;
            this.tableR_ = tableR;
            this.binnerR_ = binnerR;
            this.linksetCreator_ = linksetCreator;
        }

        @Override
        public LinkSet createAccumulator() {
            return this.linksetCreator_.get();
        }

        @Override
        public LinkSet combine(LinkSet links1, LinkSet links2) {
            LinkSet addendum;
            LinkSet result;
            if (links1.size() > links2.size()) {
                result = links1;
                addendum = links2;
            } else {
                result = links2;
                addendum = links1;
            }
            for (RowLink link : addendum) {
                result.addLink(link);
            }
            return result;
        }

        @Override
        public void accumulateRows(RowSplittable rseqS, LinkSet linkSet) throws IOException {
            MatchKit matchKit = this.kitFact_.get();
            Predicate<Object[]> inclusion = this.rowSelector_.get();
            LongSupplier rowIndexS = rseqS.rowIndex();
            assert (rowIndexS != null);
            try (RowAccess accessR = this.tableR_.getRowAccess();){
                ArrayList<RowLink2> linkList = new ArrayList<RowLink2>();
                HashSet<Long> rrowSet = new HashSet<Long>();
                while (rseqS.next()) {
                    Object[] rowS = rseqS.getRow();
                    if (!inclusion.test(rowS)) continue;
                    Object[] keys = matchKit.getBins(rowS);
                    rrowSet.clear();
                    for (Object object : keys) {
                        long[] rrows = this.binnerR_.getLongs(object);
                        if (rrows == null) continue;
                        for (long lrow : rrows) {
                            rrowSet.add(lrow);
                        }
                    }
                    int nr = rrowSet.size();
                    if (nr <= 0) continue;
                    long[] rrows = new long[nr];
                    int ir = 0;
                    for (Long rr : rrowSet) {
                        rrows[ir++] = rr;
                    }
                    Arrays.sort(rrows);
                    long l = rowIndexS.getAsLong();
                    linkList.clear();
                    double bestScore = Double.MAX_VALUE;
                    for (long irR : rrows) {
                        accessR.setRowIndex(irR);
                        Object[] rowR = accessR.getRow();
                        double score = matchKit.matchScore(rowS, rowR);
                        if (!(score >= 0.0) || this.bestOnly_ && !(score < bestScore)) continue;
                        RowRef refR = new RowRef(this.indexR_, irR);
                        RowRef refS = new RowRef(this.indexS_, l);
                        RowLink2 pairLink = new RowLink2(refR, refS);
                        pairLink.setScore(score);
                        if (this.bestOnly_) {
                            bestScore = score;
                            linkList.clear();
                        }
                        linkList.add(pairLink);
                        assert (!this.bestOnly_ || linkList.size() == 1);
                    }
                    Object object = linkList.iterator();
                    while (object.hasNext()) {
                        RowLink2 pairLink = (RowLink2)object.next();
                        assert (!linkSet.containsLink(pairLink));
                        linkSet.addLink(pairLink);
                    }
                }
            }
        }
    }

    private static class RefCollector
    extends RowCollector<SplitBinnedRefs> {
        private final Supplier<MatchKit> kitFact_;
        private final Supplier<Predicate<Object[]>> rowSelector_;
        private final int tIndex_;
        private final Predicate<Object> canAddKey_;
        private final Supplier<ObjectBinner<Object, RowRef>> binnerFactory_;

        RefCollector(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, int tIndex, Predicate<Object> canAddKey, Supplier<ObjectBinner<Object, RowRef>> binnerFactory) {
            this.kitFact_ = kitFact;
            this.rowSelector_ = rowSelector;
            this.tIndex_ = tIndex;
            this.canAddKey_ = canAddKey;
            this.binnerFactory_ = binnerFactory;
        }

        @Override
        public SplitBinnedRefs createAccumulator() {
            return new SplitBinnedRefs(this.binnerFactory_.get());
        }

        @Override
        public SplitBinnedRefs combine(SplitBinnedRefs binned1, SplitBinnedRefs binned2) {
            if (binned1.binner_.getBinCount() > binned2.binner_.getBinCount()) {
                binned1.addBinnedRefs(binned2);
                return binned1;
            }
            binned2.addBinnedRefs(binned1);
            return binned2;
        }

        @Override
        public void accumulateRows(RowSplittable rseq, SplitBinnedRefs binned) throws IOException {
            MatchKit matchKit = this.kitFact_.get();
            Predicate<Object[]> inclusion = this.rowSelector_.get();
            ObjectBinner<Object, RowRef> binner = binned.binner_;
            int nin = 0;
            LongSupplier rowIndex = rseq.rowIndex();
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                if (!inclusion.test(row)) continue;
                ++nin;
                Object[] keys = matchKit.getBins(row);
                if (keys.length <= 0) continue;
                long lrow = rowIndex.getAsLong();
                RowRef rref = new RowRef(this.tIndex_, lrow);
                for (Object key : keys) {
                    if (!this.canAddKey_.test(key)) continue;
                    binner.addItem(key, rref);
                }
            }
            binned.ninclude_ += (long)nin;
        }
    }

    private static class BinCollector
    extends RowCollector<SplitBinnedRows> {
        private final Supplier<MatchKit> kitFact_;
        private final boolean isIntSize_;
        private final Supplier<Predicate<Object[]>> rowSelector_;

        BinCollector(Supplier<MatchKit> kitFact, boolean isIntSize, Supplier<Predicate<Object[]>> rowSelector) {
            this.kitFact_ = kitFact;
            this.isIntSize_ = isIntSize;
            this.rowSelector_ = rowSelector;
        }

        @Override
        public SplitBinnedRows createAccumulator() {
            return new SplitBinnedRows(Binners.createLongBinner(this.isIntSize_));
        }

        @Override
        public SplitBinnedRows combine(SplitBinnedRows binned1, SplitBinnedRows binned2) {
            return binned1.combine(binned2);
        }

        @Override
        public void accumulateRows(RowSplittable rseq, SplitBinnedRows binned) throws IOException {
            LongBinner binner = binned.binner_;
            LongSupplier rowIndex = rseq.rowIndex();
            assert (rowIndex != null);
            MatchKit matchKit = this.kitFact_.get();
            Predicate<Object[]> inclusion = this.rowSelector_.get();
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                if (inclusion.test(row)) {
                    Object[] keys = matchKit.getBins(row);
                    int nkey = keys.length;
                    if (nkey > 0) {
                        long lrow = rowIndex.getAsLong();
                        for (int ikey = 0; ikey < nkey; ++ikey) {
                            binner.addItem(keys[ikey], lrow);
                        }
                        binned.nref_ += (long)nkey;
                    }
                } else {
                    ++binned.nexclude_;
                }
                ++binned.nrow_;
            }
        }
    }

    private static class SplitBinnedRefs {
        ObjectBinner<Object, RowRef> binner_;
        long ninclude_;

        SplitBinnedRefs(ObjectBinner<Object, RowRef> binner) {
            this.binner_ = binner;
        }

        void addBinnedRefs(SplitBinnedRefs other) {
            this.ninclude_ += other.ninclude_;
            this.binner_.addContent(other.binner_);
        }
    }

    private static class SplitBinnedRows
    implements MatchComputer.BinnedRows {
        LongBinner binner_;
        long nrow_;
        long nref_;
        long nexclude_;

        SplitBinnedRows(LongBinner binner) {
            this.binner_ = binner;
        }

        @Override
        public LongBinner getLongBinner() {
            return this.binner_;
        }

        @Override
        public long getNref() {
            return this.nref_;
        }

        @Override
        public long getNexclude() {
            return this.nexclude_;
        }

        SplitBinnedRows combine(SplitBinnedRows other) {
            this.binner_ = this.binner_.combine(other.binner_);
            this.nrow_ += other.nrow_;
            this.nref_ += other.nref_;
            this.nexclude_ += other.nexclude_;
            return this;
        }
    }
}

