/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

class Profiler {
    private final Runtime runtime_ = Runtime.getRuntime();
    private final boolean isTime_;
    private final boolean isMem_;
    private long resetUsed_;
    private long resetTime_;
    private long gcTime_;

    public Profiler() {
        this(true, true);
    }

    public Profiler(boolean isTime, boolean isMem) {
        this.isTime_ = isTime;
        this.isMem_ = isMem;
    }

    public void reset() {
        this.gcTime_ = 0L;
        this.resetTime_ = System.currentTimeMillis();
        if (this.isMem_) {
            this.resetUsed_ = this.getCurrentUsedMemory();
        }
    }

    public String report() {
        long elapsedTime;
        long remainingMem;
        long usedMem;
        StringBuffer sbuf = new StringBuffer();
        if (this.isMem_) {
            usedMem = this.getCurrentUsedMemory();
            remainingMem = this.runtime_.maxMemory() - usedMem;
        } else {
            usedMem = 0L;
            remainingMem = 0L;
        }
        long l = elapsedTime = this.isTime_ ? System.currentTimeMillis() - this.resetTime_ : 0L;
        if (this.isTime_) {
            if (sbuf.length() > 0) {
                sbuf.append("; ");
            }
            sbuf.append("Time: ").append(this.formatTime(elapsedTime));
            if (this.isMem_) {
                sbuf.append(" (gc: ").append(this.formatTime(this.gcTime_)).append(")");
            }
        }
        if (this.isMem_) {
            if (sbuf.length() > 0) {
                sbuf.append("; ");
            }
            sbuf.append("Mem: ").append(this.formatMemory(this.resetUsed_)).append(" -> ").append(this.formatMemory(usedMem)).append(", remaining ").append(this.formatMemory(remainingMem));
        }
        return sbuf.toString();
    }

    public String formatMemory(long nbyte) {
        int megas = (int)Math.round((double)nbyte / 1024.0 / 1024.0);
        return megas + "M";
    }

    public String formatTime(long millis) {
        long tenths = millis / 100L;
        return tenths / 10L + "." + tenths % 10L + "s";
    }

    public long getCurrentUsedMemory() {
        long startGc = System.currentTimeMillis();
        this.runtime_.gc();
        this.gcTime_ += System.currentTimeMillis() - startGc;
        return this.runtime_.totalMemory() - this.runtime_.freeMemory();
    }
}

