/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.CuboidCoverage;
import uk.ac.starlink.table.join.MatchKit;

public class SphericalPolarMatchEngine
extends AbstractCartesianMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERR_INFO)};
    private static final DefaultValueInfo R_INFO = new DefaultValueInfo("Distance", Number.class, "Distance from origin");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Cartesian distance between matched points");
    private static final DefaultValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Maximum Cartesian separation for match");

    public SphericalPolarMatchEngine(double err) {
        super(3);
        this.setIsotropicScale(err);
    }

    public void setError(double err) {
        this.setIsotropicScale(err);
    }

    public double getError() {
        return this.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO, R_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<AbstractCartesianMatchEngine.CartesianBinner> binnerFact = this.createBinnerFactory();
        double error = this.getError();
        XyzReader xyzReader = this::toXyz;
        return () -> new SphericalPolarMatchKit(error, (AbstractCartesianMatchEngine.CartesianBinner)binnerFact.get(), xyzReader);
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double error = this.getError();
        double[] errs = new double[]{error, error, error};
        return () -> CuboidCoverage.createFixedErrorCoverage(3, errs, this::toXyz);
    }

    @Override
    public double getScoreScale() {
        return this.getError();
    }

    @Override
    public String toString() {
        return "Sky 3D";
    }

    boolean toXyz(Object[] tuple, double[] xyz) {
        return SphericalPolarMatchEngine.toXyzRadians(SphericalPolarMatchEngine.getNumberValue(tuple[0]), SphericalPolarMatchEngine.getNumberValue(tuple[1]), SphericalPolarMatchEngine.getNumberValue(tuple[2]), xyz);
    }

    static boolean toXyzRadians(double raRad, double decRad, double r, double[] xyz) {
        if (Double.isNaN(raRad) || Double.isNaN(decRad) || Double.isNaN(r)) {
            xyz[0] = Double.NaN;
            xyz[1] = Double.NaN;
            xyz[2] = Double.NaN;
            return false;
        }
        double cd = Math.cos(decRad);
        double sd = Math.sin(decRad);
        double cr = Math.cos(raRad);
        double sr = Math.sin(raRad);
        double x = r * cr * cd;
        double y = r * sr * cd;
        double z = r * sd;
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return true;
    }

    static {
        ERR_INFO.setUnitString("units of distance");
    }

    public static class InDegrees
    extends SphericalPolarMatchEngine {
        private final ValueInfo[] tupleInfos_;
        private static final double FROM_DEG = Math.PI / 180;

        public InDegrees(double err) {
            super(err);
            ValueInfo[] infos0 = super.getTupleInfos();
            this.tupleInfos_ = new ValueInfo[]{AbstractSkyMatchEngine.inDegreeInfo(infos0[0]), AbstractSkyMatchEngine.inDegreeInfo(infos0[1]), infos0[2]};
            assert (this.tupleInfos_.length == infos0.length);
        }

        @Override
        boolean toXyz(Object[] tuple, double[] xyz) {
            return InDegrees.toXyzRadians(InDegrees.getNumberValue(tuple[0]) * (Math.PI / 180), InDegrees.getNumberValue(tuple[1]) * (Math.PI / 180), InDegrees.getNumberValue(tuple[2]), xyz);
        }

        @Override
        public ValueInfo[] getTupleInfos() {
            return this.tupleInfos_;
        }
    }

    private static class SphericalPolarMatchKit
    implements MatchKit {
        final double error_;
        final AbstractCartesianMatchEngine.CartesianBinner binner_;
        final XyzReader xyzReader_;
        final double[] xyz0_;
        final double[] xyz1_;
        final double[] xyz2_;

        SphericalPolarMatchKit(double error, AbstractCartesianMatchEngine.CartesianBinner binner, XyzReader xyzReader) {
            this.error_ = error;
            this.binner_ = binner;
            this.xyzReader_ = xyzReader;
            this.xyz0_ = new double[3];
            this.xyz1_ = new double[3];
            this.xyz2_ = new double[3];
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            this.xyzReader_.toXyz(tuple1, this.xyz1_);
            this.xyzReader_.toXyz(tuple2, this.xyz2_);
            return AbstractCartesianMatchEngine.matchScore(3, this.xyz1_, this.xyz2_, this.error_);
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            this.xyzReader_.toXyz(tuple, this.xyz0_);
            return this.binner_.getRadiusBins(this.xyz0_, this.error_ * 0.5);
        }
    }

    @FunctionalInterface
    private static interface XyzReader {
        public boolean toXyz(Object[] var1, double[] var2);
    }
}

