/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import java.util.ArrayList;
import java.util.HashMap;

public class Annotation
implements Element {
    protected int annotationtype;
    protected HashMap annotationAttributes = new HashMap();
    protected float llx = Float.NaN;
    protected float lly = Float.NaN;
    protected float urx = Float.NaN;
    protected float ury = Float.NaN;

    public Annotation(Annotation annotation) {
        this.annotationtype = annotation.annotationtype;
        this.annotationAttributes = annotation.annotationAttributes;
        this.llx = annotation.llx;
        this.lly = annotation.lly;
        this.urx = annotation.urx;
        this.ury = annotation.ury;
    }

    public int type() {
        return 29;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void setDimensions(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public float llx() {
        return this.llx;
    }

    public float lly() {
        return this.lly;
    }

    public float urx() {
        return this.urx;
    }

    public float ury() {
        return this.ury;
    }

    public float llx(float f) {
        if (Float.isNaN(this.llx)) {
            return f;
        }
        return this.llx;
    }

    public float lly(float f) {
        if (Float.isNaN(this.lly)) {
            return f;
        }
        return this.lly;
    }

    public float urx(float f) {
        if (Float.isNaN(this.urx)) {
            return f;
        }
        return this.urx;
    }

    public float ury(float f) {
        if (Float.isNaN(this.ury)) {
            return f;
        }
        return this.ury;
    }

    public int annotationType() {
        return this.annotationtype;
    }

    public String title() {
        String string = (String)this.annotationAttributes.get("title");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String content() {
        String string = (String)this.annotationAttributes.get("content");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public HashMap attributes() {
        return this.annotationAttributes;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return true;
    }
}

