/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import java.util.ArrayList;
import java.util.HashMap;

public class Chunk
implements Element {
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap attributes = null;

    public Chunk() {
        this.content = new StringBuffer();
        this.font = new Font();
    }

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(Image image, float f, float f2) {
        this("\ufffc", new Font());
        Image image2 = Image.getInstance(image);
        image2.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute("IMAGE", new Object[]{image2, new Float(f), new Float(f2), Boolean.FALSE});
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 10;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        return this.content.toString();
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap hashMap) {
        this.attributes = hashMap;
    }

    private Chunk setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
        return this;
    }

    public Chunk setHyphenation(HyphenationEvent hyphenationEvent) {
        return this.setAttribute("HYPHENATION", hyphenationEvent);
    }

    public Chunk setLocalGoto(String string) {
        return this.setAttribute("LOCALGOTO", string);
    }

    public Chunk setLocalDestination(String string) {
        return this.setAttribute("LOCALDESTINATION", string);
    }

    public Chunk setAnchor(String string) {
        return this.setAttribute("ACTION", new PdfAction(string));
    }

    public Chunk setNewPage() {
        return this.setAttribute("NEWPAGE", null);
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return true;
    }

    public HyphenationEvent getHyphenation() {
        if (this.attributes == null) {
            return null;
        }
        return (HyphenationEvent)this.attributes.get("HYPHENATION");
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

