/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfFormField
extends PdfAnnotation {
    public static final PdfName IF_SCALE_ALWAYS = PdfName.A;
    public static final PdfName IF_SCALE_BIGGER = PdfName.B;
    public static final PdfName IF_SCALE_SMALLER = PdfName.S;
    public static final PdfName IF_SCALE_NEVER = PdfName.N;
    public static final PdfName IF_SCALE_ANAMORPHIC = PdfName.A;
    public static final PdfName IF_SCALE_PROPORTIONAL = PdfName.P;
    static PdfName[] mergeTarget = new PdfName[]{PdfName.FONT, PdfName.XOBJECT, PdfName.COLORSPACE, PdfName.PATTERN};
    protected PdfFormField parent;
    protected ArrayList kids;

    protected PdfFormField(PdfWriter pdfWriter) {
        super(pdfWriter, null);
        this.form = true;
        this.annotation = false;
    }

    public PdfFormField getParent() {
        return this.parent;
    }

    public ArrayList getKids() {
        return this.kids;
    }

    static void mergeResources(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfStamperImp pdfStamperImp) {
        PdfDictionary pdfDictionary3 = null;
        PdfDictionary pdfDictionary4 = null;
        PdfName pdfName = null;
        for (int i = 0; i < mergeTarget.length; ++i) {
            pdfName = mergeTarget[i];
            PdfDictionary pdfDictionary5 = pdfDictionary2.getAsDict(pdfName);
            pdfDictionary3 = pdfDictionary5;
            if (pdfDictionary3 == null) continue;
            pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(pdfName), pdfDictionary);
            if (pdfDictionary4 == null) {
                pdfDictionary4 = new PdfDictionary();
            }
            pdfDictionary4.mergeDifferent(pdfDictionary3);
            pdfDictionary.put(pdfName, pdfDictionary4);
            if (pdfStamperImp == null) continue;
            pdfStamperImp.markUsed(pdfDictionary4);
        }
    }

    static void mergeResources(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        PdfFormField.mergeResources(pdfDictionary, pdfDictionary2, null);
    }

    public void setUsed() {
        PdfObject pdfObject;
        this.used = true;
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.getIndirectReference());
        }
        if (this.kids != null) {
            pdfObject = new PdfArray();
            for (int i = 0; i < this.kids.size(); ++i) {
                ((PdfArray)pdfObject).add(((PdfFormField)this.kids.get(i)).getIndirectReference());
            }
            this.put(PdfName.KIDS, pdfObject);
        }
        if (this.templates == null) {
            return;
        }
        pdfObject = new PdfDictionary();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)iterator.next();
            PdfFormField.mergeResources((PdfDictionary)pdfObject, (PdfDictionary)pdfTemplate.getResources());
        }
        this.put(PdfName.DR, pdfObject);
    }

    public static PdfAnnotation shallowDuplicate(PdfAnnotation pdfAnnotation) {
        PdfAnnotation pdfAnnotation2;
        if (pdfAnnotation.isForm()) {
            pdfAnnotation2 = new PdfFormField(pdfAnnotation.writer);
            PdfFormField pdfFormField = pdfAnnotation2;
            PdfFormField pdfFormField2 = (PdfFormField)pdfAnnotation;
            pdfFormField.parent = pdfFormField2.parent;
            pdfFormField.kids = pdfFormField2.kids;
        } else {
            pdfAnnotation2 = new PdfAnnotation(pdfAnnotation.writer, null);
        }
        pdfAnnotation2.merge(pdfAnnotation);
        pdfAnnotation2.form = pdfAnnotation.form;
        pdfAnnotation2.annotation = pdfAnnotation.annotation;
        pdfAnnotation2.templates = pdfAnnotation.templates;
        return pdfAnnotation2;
    }
}

