/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.events.PdfPCellEventForwarder;

public class PdfPCell
extends Rectangle {
    private ColumnText column = new ColumnText(null);
    private int verticalAlignment = 4;
    private float paddingLeft = 2.0f;
    private float paddingRight = 2.0f;
    private float paddingTop = 2.0f;
    private float paddingBottom = 2.0f;
    private float fixedHeight = 0.0f;
    private float minimumHeight;
    private boolean noWrap = false;
    private PdfPTable table;
    private int colspan = 1;
    private int rowspan = 1;
    private Image image;
    private PdfPCellEvent cellEvent;
    private boolean useDescender;
    private boolean useBorderPadding = false;
    protected Phrase phrase;
    private int rotation;

    public PdfPCell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.column.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
        this.column.addText(this.phrase);
        this.column.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Image image, boolean bl) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        if (bl) {
            this.image = image;
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(this.borderWidth / 2.0f);
        } else {
            this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
            this.column.addText(this.phrase);
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(PdfPTable pdfPTable) {
        this(pdfPTable, null);
    }

    public PdfPCell(PdfPTable pdfPTable, PdfPCell pdfPCell) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.column.setLeading(0.0f, 1.0f);
        this.table = pdfPTable;
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setExtendLastRow(true);
        this.column.addElement(pdfPTable);
        if (pdfPCell != null) {
            this.cloneNonPositionParameters(pdfPCell);
            this.verticalAlignment = pdfPCell.verticalAlignment;
            this.paddingLeft = pdfPCell.paddingLeft;
            this.paddingRight = pdfPCell.paddingRight;
            this.paddingTop = pdfPCell.paddingTop;
            this.paddingBottom = pdfPCell.paddingBottom;
            this.colspan = pdfPCell.colspan;
            this.rowspan = pdfPCell.rowspan;
            this.cellEvent = pdfPCell.cellEvent;
            this.useDescender = pdfPCell.useDescender;
            this.useBorderPadding = pdfPCell.useBorderPadding;
            this.rotation = pdfPCell.rotation;
        } else {
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(PdfPCell pdfPCell) {
        super(pdfPCell.llx, pdfPCell.lly, pdfPCell.urx, pdfPCell.ury);
        this.cloneNonPositionParameters(pdfPCell);
        this.verticalAlignment = pdfPCell.verticalAlignment;
        this.paddingLeft = pdfPCell.paddingLeft;
        this.paddingRight = pdfPCell.paddingRight;
        this.paddingTop = pdfPCell.paddingTop;
        this.paddingBottom = pdfPCell.paddingBottom;
        this.phrase = pdfPCell.phrase;
        this.fixedHeight = pdfPCell.fixedHeight;
        this.minimumHeight = pdfPCell.minimumHeight;
        this.noWrap = pdfPCell.noWrap;
        this.colspan = pdfPCell.colspan;
        this.rowspan = pdfPCell.rowspan;
        if (pdfPCell.table != null) {
            this.table = new PdfPTable(pdfPCell.table);
        }
        this.image = Image.getInstance(pdfPCell.image);
        this.cellEvent = pdfPCell.cellEvent;
        this.useDescender = pdfPCell.useDescender;
        this.column = ColumnText.duplicate(pdfPCell.column);
        this.useBorderPadding = pdfPCell.useBorderPadding;
        this.rotation = pdfPCell.rotation;
    }

    public void addElement(Element element) {
        if (this.table != null) {
            this.table = null;
            this.column.setText(null);
        }
        this.column.addElement(element);
    }

    public void setPhrase(Phrase phrase) {
        this.table = null;
        this.image = null;
        this.phrase = phrase;
        this.column.setText(this.phrase);
    }

    public int getHorizontalAlignment() {
        return this.column.getAlignment();
    }

    public void setHorizontalAlignment(int n) {
        this.column.setAlignment(n);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (this.table != null) {
            this.table.setExtendLastRow(n == 4);
        }
        this.verticalAlignment = n;
    }

    public float getEffectivePaddingLeft() {
        if (this.isUseBorderPadding()) {
            float f = this.getBorderWidthLeft() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingLeft + f;
        }
        return this.paddingLeft;
    }

    public void setPaddingLeft(float f) {
        this.paddingLeft = f;
    }

    public float getEffectivePaddingRight() {
        if (this.isUseBorderPadding()) {
            float f = this.getBorderWidthRight() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingRight + f;
        }
        return this.paddingRight;
    }

    public void setPaddingRight(float f) {
        this.paddingRight = f;
    }

    public float getEffectivePaddingTop() {
        if (this.isUseBorderPadding()) {
            float f = this.getBorderWidthTop() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingTop + f;
        }
        return this.paddingTop;
    }

    public void setPaddingTop(float f) {
        this.paddingTop = f;
    }

    public float getEffectivePaddingBottom() {
        if (this.isUseBorderPadding()) {
            float f = this.getBorderWidthBottom() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.paddingBottom + f;
        }
        return this.paddingBottom;
    }

    public void setPaddingBottom(float f) {
        this.paddingBottom = f;
    }

    public void setPadding(float f) {
        this.paddingBottom = f;
        this.paddingTop = f;
        this.paddingLeft = f;
        this.paddingRight = f;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public void setUseBorderPadding(boolean bl) {
        this.useBorderPadding = bl;
    }

    public void setLeading(float f, float f2) {
        this.column.setLeading(f, f2);
    }

    public void setFixedHeight(float f) {
        this.fixedHeight = f;
        this.minimumHeight = 0.0f;
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public boolean hasFixedHeight() {
        return this.getFixedHeight() > 0.0f;
    }

    public void setMinimumHeight(float f) {
        this.minimumHeight = f;
        this.fixedHeight = 0.0f;
    }

    public float getMinimumHeight() {
        return this.minimumHeight;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean bl) {
        this.noWrap = bl;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int n) {
        this.colspan = n;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int n) {
        this.rowspan = n;
    }

    public void setRunDirection(int n) {
        this.column.setRunDirection(n);
    }

    public int getRunDirection() {
        return this.column.getRunDirection();
    }

    public Image getImage() {
        return this.image;
    }

    public PdfPCellEvent getCellEvent() {
        return this.cellEvent;
    }

    public void setCellEvent(PdfPCellEvent pdfPCellEvent) {
        if (pdfPCellEvent == null) {
            this.cellEvent = null;
        } else if (this.cellEvent == null) {
            this.cellEvent = pdfPCellEvent;
        } else if (this.cellEvent instanceof PdfPCellEventForwarder) {
            ((PdfPCellEventForwarder)this.cellEvent).addCellEvent(pdfPCellEvent);
        } else {
            PdfPCellEventForwarder pdfPCellEventForwarder = new PdfPCellEventForwarder();
            pdfPCellEventForwarder.addCellEvent(this.cellEvent);
            pdfPCellEventForwarder.addCellEvent(pdfPCellEvent);
            this.cellEvent = pdfPCellEventForwarder;
        }
    }

    public void setUseAscender(boolean bl) {
        this.column.setUseAscender(bl);
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseDescender(boolean bl) {
        this.useDescender = bl;
    }

    public ColumnText getColumn() {
        return this.column;
    }

    public void setColumn(ColumnText columnText) {
        this.column = columnText;
    }

    public int getRotation() {
        return this.rotation;
    }

    void consumeHeight(float f) {
        float f2 = this.getRight() - this.getEffectivePaddingRight();
        float f3 = this.getLeft() + this.getEffectivePaddingLeft();
        float f4 = f - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom();
        if (this.getRotation() != 90 && this.getRotation() != 270) {
            this.column.setSimpleColumn(f3, f4 + 0.001f, f2, 0.0f);
        } else {
            this.column.setSimpleColumn(0.0f, f3, f4 + 0.001f, f2);
        }
        try {
            this.column.go(true);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public float getMaxHeight() {
        float f;
        boolean bl = this.getRotation() == 90 || this.getRotation() == 270;
        Image image = this.getImage();
        if (image != null) {
            image.scalePercent(100.0f);
            f = bl ? image.getScaledHeight() : image.getScaledWidth();
            float f2 = (this.getRight() - this.getEffectivePaddingRight() - this.getEffectivePaddingLeft() - this.getLeft()) / f;
            image.scalePercent(f2 * 100.0f);
            float f3 = bl ? image.getScaledWidth() : image.getScaledHeight();
            this.setBottom(this.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - f3);
        } else if (bl && this.hasFixedHeight()) {
            this.setBottom(this.getTop() - this.getFixedHeight());
        } else {
            float f4;
            float f5;
            float f6;
            float f7;
            ColumnText columnText = ColumnText.duplicate(this.getColumn());
            if (bl) {
                f7 = 20000.0f;
                f6 = this.getRight() - this.getEffectivePaddingRight();
                f5 = 0.0f;
                f4 = this.getLeft() + this.getEffectivePaddingLeft();
            } else {
                f7 = this.isNoWrap() ? 20000.0f : this.getRight() - this.getEffectivePaddingRight();
                f6 = this.getTop() - this.getEffectivePaddingTop();
                f5 = this.getLeft() + this.getEffectivePaddingLeft();
                f4 = this.hasFixedHeight() ? f6 + this.getEffectivePaddingBottom() - this.getFixedHeight() : -1.0737418E9f;
            }
            PdfPRow.setColumn(columnText, f5, f4, f7, f6);
            try {
                columnText.go(true);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
            if (bl) {
                this.setBottom(this.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - columnText.getFilledWidth());
            } else {
                float f8 = columnText.getYLine();
                if (this.isUseDescender()) {
                    f8 += columnText.getDescender();
                }
                this.setBottom(f8 - this.getEffectivePaddingBottom());
            }
        }
        f = this.getHeight();
        if (f < this.getFixedHeight()) {
            f = this.getFixedHeight();
        } else if (f < this.getMinimumHeight()) {
            f = this.getMinimumHeight();
        }
        return f;
    }
}

