/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import uk.ac.starlink.auth.AuthConnection;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.Redirector;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.auth.UserInterface;

public class Get {
    private static final int BUFSIZ = 16384;
    private static final Logger rootLogger_ = Logger.getLogger("");
    private static final Logger logger_ = Logger.getLogger(Get.class.getName());

    public static void main(String[] args) throws IOException {
        if (!Get.runMain(args)) {
            System.exit(1);
        }
    }

    public static boolean runMain(String[] args) throws IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String cmdName = Get.class.getName();
        if (argList.size() > 1 && "--cmd-name".equals(argList.get(0))) {
            argList.remove(0);
            cmdName = (String)argList.remove(0);
        }
        String usage = String.join((CharSequence)"\n   ", "", "Usage: " + cmdName + " [options...] <url>", "", "   -o, --output <file>           output to file", "   -u, --username <txt>|@<file>  supply username", "   -p, --password <txt>|@<file>  supply password", "   -c, --curl                    report equivalent curl command", "   -s, --show-secret             include secret information in curl report", "   -n, --no-download             don't actually read the resource", "   -v, --verbose                 increase verbosity (may be repeated)", "   +v, --no-verbose              decrease verbosity (may be repeated)", "   -h, --help                    display this message", "");
        URL url = null;
        File outfile = null;
        boolean showCurl = false;
        boolean showSecret = false;
        boolean isDownload = true;
        Object username = null;
        Object password = null;
        int verbosity = 0;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (Get.flagMatch(arg, "h", "help")) {
                it.remove();
                System.err.println(usage);
                return true;
            }
            if (Get.flagMatch(arg, "o", "output") && it.hasNext()) {
                it.remove();
                outfile = new File((String)it.next());
                it.remove();
                continue;
            }
            if (Get.flagMatch(arg, "c", "curl")) {
                it.remove();
                showCurl = true;
                continue;
            }
            if (Get.flagMatch(arg, "n", "no-download")) {
                it.remove();
                isDownload = false;
                continue;
            }
            if (Get.flagMatch(arg, "v", "verbose")) {
                it.remove();
                ++verbosity;
                continue;
            }
            if (Get.flagMatch(arg, "u", "username") && it.hasNext()) {
                it.remove();
                System.setProperty("auth.username", (String)it.next());
                it.remove();
                continue;
            }
            if (Get.flagMatch(arg, "p", "password") && it.hasNext()) {
                it.remove();
                System.setProperty("auth.password", (String)it.next());
                it.remove();
                continue;
            }
            if ("+v".equals(arg) || "--no-verbose".equals(arg)) {
                it.remove();
                --verbosity;
                continue;
            }
            if (Get.flagMatch(arg, "s", "show-secret")) {
                it.remove();
                showSecret = true;
                continue;
            }
            try {
                url = new URI(arg).toURL();
                it.remove();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                System.err.println(usage);
                return false;
            }
        }
        if (url == null || !argList.isEmpty()) {
            System.err.println(usage);
            return false;
        }
        int verbInt = Math.max(Level.ALL.intValue(), Level.WARNING.intValue() - verbosity * (Level.WARNING.intValue() - Level.INFO.intValue()));
        Level verbLevel = Level.parse(Integer.toString(verbInt));
        Handler[] rootHandlers = rootLogger_.getHandlers();
        if (rootHandlers.length > 0) {
            rootHandlers[0].setLevel(verbLevel);
        }
        rootLogger_.setLevel(verbLevel);
        AuthManager manager = AuthManager.getInstance();
        UserInterface propsUi = UserInterface.getPropertiesUi();
        manager.setUserInterface(propsUi == null ? UserInterface.CLI : propsUi);
        UrlConnector connector = null;
        Redirector redirector = Redirector.DEFAULT;
        AuthConnection authConn = manager.makeConnection(url, connector, redirector);
        if (showCurl) {
            AuthContext context = authConn.getContext();
            ArrayList<String> curlWords = new ArrayList<String>();
            curlWords.add("curl");
            curlWords.addAll(Arrays.asList(context.getCurlArgs(url, showSecret)));
            if (outfile != null) {
                curlWords.add("-o");
                curlWords.add(outfile.toString());
            }
            curlWords.add(url.toString());
            System.err.println(curlWords.stream().map(Get::shellEscape).collect(Collectors.joining(" ")));
        }
        if (isDownload) {
            long nbyte = 0L;
            try (InputStream in = authConn.getConnection().getInputStream();){
                int n;
                OutputStream out = outfile == null ? System.out : new FileOutputStream(outfile);
                byte[] buf = new byte[16384];
                while ((n = in.read(buf)) > 0) {
                    out.write(buf, 0, n);
                    nbyte += (long)n;
                }
                out.flush();
                if (outfile != null) {
                    out.close();
                }
                logger_.info(nbyte + " bytes written");
            }
        }
        return true;
    }

    private static boolean flagMatch(String arg, String ... flagAlternatives) {
        String baseArg;
        if (arg.startsWith("--")) {
            baseArg = arg.substring(2);
        } else if (arg.startsWith("-")) {
            baseArg = arg.substring(1);
        } else {
            return false;
        }
        return Arrays.stream(flagAlternatives).anyMatch(flag -> baseArg.equals(flag));
    }

    private static String shellEscape(String txt) {
        if (!(txt = txt.trim().replaceAll("\\s+", " ")).matches(".*[ $?'\"].*")) {
            return txt;
        }
        if (txt.indexOf("'") < 0) {
            return "'" + txt + "'";
        }
        if (txt.indexOf(34) < 0) {
            return '\"' + txt + '\"';
        }
        return "'" + txt.replaceAll("'", "'\"'\"'") + "'";
    }
}

