/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.cdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.EpochFormatter;
import uk.ac.bristol.star.cdf.TtScaler;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;

public class CdfDomains {
    private static final double AD0_UNIX_SECONDS = (double)EpochFormatter.AD0_UNIX_MILLIS * 0.001;
    private static final Map<DataType, DomainMapper> mapperMap_ = CdfDomains.createMapperMap();

    public static DomainMapper getMapper(DataType dtype) {
        if (dtype != null && dtype.getName().equals(DataType.TIME_TT2000.getName())) {
            dtype = DataType.TIME_TT2000;
        }
        return mapperMap_.get(dtype);
    }

    private static Map<DataType, DomainMapper> createMapperMap() {
        HashMap<DataType, TimeMapper> map = new HashMap<DataType, TimeMapper>();
        map.put(DataType.EPOCH, new EpochTimeMapper());
        map.put(DataType.EPOCH16, new Epoch16TimeMapper());
        map.put(DataType.TIME_TT2000, new Tt2000TimeMapper());
        return Collections.unmodifiableMap(map);
    }

    private static class Tt2000TimeMapper
    extends TimeMapper {
        private int iLastScaler_;
        private final TtScaler[] scalers_ = TtScaler.getTtScalers();

        Tt2000TimeMapper() {
            super(Long.class, "CDF_TIME_TT2000", "TT milliseconds since J2000");
        }

        public double toUnixSeconds(Object value) {
            if (value instanceof Long) {
                int index;
                long timeTt2k = (Long)value;
                long tt2kMillis = timeTt2k / 1000000L;
                int plusNanos = (int)(timeTt2k % 1000000L);
                if (plusNanos < 0) {
                    --tt2kMillis;
                    plusNanos += 1000000;
                }
                this.iLastScaler_ = index = TtScaler.getScalerIndex(tt2kMillis, this.scalers_, this.iLastScaler_);
                return this.scalers_[index].tt2kToUnixMillis(tt2kMillis) * 0.001 + (double)plusNanos * 1.0E-9;
            }
            return Double.NaN;
        }
    }

    private static class Epoch16TimeMapper
    extends TimeMapper {
        Epoch16TimeMapper() {
            super(double[].class, "CDF_EPOCH16", "[seconds, picoseconds] since AD 0");
        }

        public double toUnixSeconds(Object value) {
            if (value instanceof double[]) {
                double[] array = (double[])value;
                if (array.length == 2) {
                    double ad0Seconds = array[0];
                    double plusPicos = array[1];
                    return AD0_UNIX_SECONDS + ad0Seconds + plusPicos * 1.0E-12;
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
    }

    private static class EpochTimeMapper
    extends TimeMapper {
        EpochTimeMapper() {
            super(Double.class, "CDF_EPOCH", "Milliseconds since AD 0");
        }

        public double toUnixSeconds(Object value) {
            if (value instanceof Double) {
                double ad0Millis = (Double)value;
                double ad0Seconds = ad0Millis * 0.001;
                return AD0_UNIX_SECONDS + ad0Seconds;
            }
            return Double.NaN;
        }
    }
}

