/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pal;

public class AOParams {
    private double geolat;
    private double geolatsin;
    private double geolatcos;
    private double abb;
    private double height;
    private double ambtemp;
    private double pressure;
    private double relhumid;
    private double wavelength;
    private double lapserate;
    private double refractA;
    private double refractB;
    private double longplus;
    private double localtime;

    public AOParams() {
        this.geolat = 0.0;
        this.geolatsin = 0.0;
        this.geolatcos = 0.0;
        this.abb = 0.0;
        this.height = 0.0;
        this.ambtemp = 0.0;
        this.pressure = 0.0;
        this.relhumid = 0.0;
        this.wavelength = 0.0;
        this.lapserate = 0.0;
        this.refractA = 0.0;
        this.refractB = 0.0;
        this.longplus = 0.0;
        this.localtime = 0.0;
    }

    public AOParams(double glat, double mag, double ht, double temp, double pres, double humid, double wavel, double lapse, double ra, double rb, double longr, double loc) {
        this.geolat = glat;
        this.geolatsin = Math.sin(glat);
        this.geolatcos = Math.cos(glat);
        this.abb = mag;
        this.height = ht;
        this.ambtemp = temp;
        this.pressure = pres;
        this.relhumid = humid;
        this.wavelength = wavel;
        this.lapserate = lapse;
        this.refractA = ra;
        this.refractB = rb;
        this.longplus = longr;
        this.localtime = loc;
    }

    public double getLat() {
        return this.geolat;
    }

    public double getLatsin() {
        return this.geolatsin;
    }

    public double getLatcos() {
        return this.geolatcos;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDabb() {
        return this.abb;
    }

    public double getTemp() {
        return this.ambtemp;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getHumidity() {
        return this.relhumid;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public double getLapserate() {
        return this.lapserate;
    }

    public double getRefractA() {
        return this.refractA;
    }

    public double getRefractB() {
        return this.refractB;
    }

    public double getLongplus() {
        return this.longplus;
    }

    public double getLocalTime() {
        return this.localtime;
    }

    public void setLat(double g) {
        this.geolat = g;
        this.geolatsin = Math.sin(g);
        this.geolatcos = Math.cos(g);
    }

    public void setDabb(double dabb) {
        this.abb = dabb;
    }

    public void setHeight(double h) {
        this.height = h;
    }

    public void setTemp(double a) {
        this.ambtemp = a;
    }

    public void setPressure(double p) {
        this.pressure = p;
    }

    public void setHumidity(double rh) {
        this.relhumid = rh;
    }

    public void setWavelength(double wl) {
        this.wavelength = wl;
    }

    public void setLapserate(double lr) {
        this.lapserate = lr;
    }

    public void setRefractA(double rfa) {
        this.refractA = rfa;
    }

    public void setRefractB(double rfb) {
        this.refractB = rfb;
    }

    public void setLongplus(double lplus) {
        this.longplus = lplus;
    }

    public void setLocalTime(double lt) {
        this.localtime = lt;
    }

    public String toString() {
        return "Parameters: " + this.geolat + " (" + this.geolatsin + "," + this.geolatcos + ")" + this.abb + " " + this.height + " " + this.ambtemp + " " + this.pressure + " " + this.relhumid + " " + this.lapserate + " " + this.refractA + " " + this.refractB + " " + this.longplus + " " + this.localtime;
    }
}

