/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import uk.ac.bristol.star.feather.BufAccess;

public class Buf {
    private final BufAccess access_;

    public Buf(BufAccess bufAccess) {
        this.access_ = bufAccess;
    }

    public byte get(long l) {
        return this.access_.get(l);
    }

    public short getLittleEndianShort(long l) {
        return (short)((this.get(l + 0L) & 0xFF) << 0 | (this.get(l + 1L) & 0xFF) << 8);
    }

    public int getLittleEndianInt(long l) {
        return (this.get(l + 0L) & 0xFF) << 0 | (this.get(l + 1L) & 0xFF) << 8 | (this.get(l + 2L) & 0xFF) << 16 | (this.get(l + 3L) & 0xFF) << 24;
    }

    public long getLittleEndianLong(long l) {
        return ((long)this.get(l + 0L) & 0xFFL) << 0 | ((long)this.get(l + 1L) & 0xFFL) << 8 | ((long)this.get(l + 2L) & 0xFFL) << 16 | ((long)this.get(l + 3L) & 0xFFL) << 24 | ((long)this.get(l + 4L) & 0xFFL) << 32 | ((long)this.get(l + 5L) & 0xFFL) << 40 | ((long)this.get(l + 6L) & 0xFFL) << 48 | ((long)this.get(l + 7L) & 0xFFL) << 56;
    }

    public float getLittleEndianFloat(long l) {
        return Float.intBitsToFloat(this.getLittleEndianInt(l));
    }

    public double getLittleEndianDouble(long l) {
        return Double.longBitsToDouble(this.getLittleEndianLong(l));
    }

    public void get(long l, byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.get(l + (long)i);
        }
    }

    public boolean isBitSet(long l) {
        return (this.get(l / 8L) & 1 << (int)l % 8) != 0;
    }
}

