/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.bristol.star.fbs.feather.CTable;
import uk.ac.bristol.star.fbs.feather.Column;
import uk.ac.bristol.star.fbs.feather.PrimitiveArray;
import uk.ac.bristol.star.feather.BufMapper;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.Decoder;
import uk.ac.bristol.star.feather.FeatherColumn;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.bristol.star.feather.Reader;

public class FeatherTable {
    private final CTable ctable_;
    private final FileChannel channel_;
    private final int ncol_;
    private final long nrow_;
    private final FeatherColumn[] columns_;
    public static final int MAGIC = 826361158;

    public FeatherTable(CTable cTable, FileChannel fileChannel) {
        this.ctable_ = cTable;
        this.channel_ = fileChannel;
        this.ncol_ = cTable.columnsLength();
        this.nrow_ = cTable.numRows();
        this.columns_ = new FeatherColumn[this.ncol_];
        for (int i = 0; i < this.ncol_; ++i) {
            Column column = cTable.columns(i);
            String string = column.name();
            PrimitiveArray primitiveArray = column.values();
            byte by = primitiveArray.type();
            long l = primitiveArray.nullCount();
            String string2 = column.userMetadata();
            byte by2 = primitiveArray.type();
            FeatherType featherType = FeatherType.fromByte(by2);
            Decoder<?> decoder = Decoder.getDecoder(featherType);
            BufMapper bufMapper = new BufMapper(fileChannel, primitiveArray.offset(), primitiveArray.totalBytes());
            this.columns_[i] = new FeatherColumn(string, this.nrow_, bufMapper, decoder, l, string2);
        }
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public FeatherColumn getColumn(int n) {
        return this.columns_[n];
    }

    public String getDescription() {
        return this.ctable_.description();
    }

    public String getMetadata() {
        return this.ctable_.metadata();
    }

    public int getFeatherVersion() {
        return this.ctable_.version();
    }

    public void close() throws IOException {
        this.channel_.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("Feather").append(" (").append(this.ncol_).append("x").append(this.nrow_).append(")").append(": ");
        for (int i = 0; i < this.ncol_; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getColumn(i));
        }
        return stringBuffer.toString();
    }

    public static FeatherTable fromFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        int n = BufUtils.readLittleEndianInt(randomAccessFile);
        if (n != 826361158) {
            throw new IOException("Not FEA1 magic number at file start");
        }
        randomAccessFile.seek(l - 8L);
        int n2 = BufUtils.readLittleEndianInt(randomAccessFile);
        int n3 = BufUtils.readLittleEndianInt(randomAccessFile);
        if (n3 != 826361158) {
            throw new IOException("Not FEA1 magic number at file start");
        }
        long l2 = l - 8L - (long)n2;
        byte[] byArray = new byte[n2];
        randomAccessFile.seek(l2);
        randomAccessFile.readFully(byArray);
        CTable cTable = CTable.getRootAsCTable(ByteBuffer.wrap(byArray));
        return new FeatherTable(cTable, randomAccessFile.getChannel());
    }

    public static boolean isMagic(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        return byArray.length >= 4 && 826361158 == ((byArray[0] & 0xFF) << 0 | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24);
    }

    public static void main(String[] stringArray) throws IOException {
        FeatherTable featherTable = FeatherTable.fromFile(new File(stringArray[0]));
        System.out.println(featherTable);
        int n = featherTable.getColumnCount();
        Reader[] readerArray = new Reader[n];
        System.out.print("#");
        for (int i = 0; i < n; ++i) {
            FeatherColumn featherColumn = featherTable.getColumn(i);
            readerArray[i] = featherColumn.createReader();
            System.out.print("\t" + featherColumn.getName());
        }
        System.out.println();
        long l = featherTable.getRowCount();
        for (long i = 0L; i < l; ++i) {
            for (int j = 0; j < n; ++j) {
                System.out.print("\t" + readerArray[j].getObject(i));
            }
            System.out.println();
        }
    }
}

